% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_data.R
\name{testData}
\alias{testData}
\title{Test data with piecewise constant mean}
\usage{
testData(
  model = c("custom", "blocks", "fms", "mix", "stairs10", "teeth10")[1],
  lengths = NULL,
  means = NULL,
  sds = NULL,
  rand.gen = rnorm,
  seed = NULL,
  ...
)
}
\arguments{
\item{model}{a string indicating from which model a realisation is to be generated;
possible values are "custom" (for user-specified model
using \code{lengths}, \code{means} and \code{sds}), and
"blocks", "fms", "mix", "stairs10", "teeth10" (for the referenced test signals)}

\item{lengths}{use iff \code{model = "custom"}; an integer vector for the lengths of the piecewise stationary segments}

\item{means}{use iff \code{model = "custom"}; a numeric vector for the means of the piecewise stationary segments}

\item{sds}{use iff \code{model = "custom"}; a numeric vector for the deviation scaling of the piecewise stationary segments.
The values are multiplied to the outcome of \code{rand.gen}, coinciding with the standard
deviation in the case of standard normal innovations (\code{rand.gen = rnorm})}

\item{rand.gen}{optional; a function to generate the noise/innovations}

\item{seed}{optional; if a seed value is provided (\code{!is.null(seed)}), 
then \code{set.seed(seed)} is called beforehand)}

\item{...}{further arguments to be parsed to \code{rand.gen}}
}
\value{
a list containing the following entries:
\itemize{
\item{x}{ a numeric vector containing a realisation of the piecewise time series model, 
given as signal + noise}
\item{mu}{ mean vector of piecewise stationary time series model }
\item{sigma}{ scaling vector of piecewise stationary time series model }
\item{cpts}{ a vector of change points in the piecewise stationary time series model }
}
}
\description{
Generate piecewise stationary time series with independent innovations and change points in the mean.
}
\details{
See Appendix B in the reference for details about the test signals.
}
\examples{
# visualise estimated changepoints by solid vertical lines
# and true changepoints by broken vertical lines
td <- testData(lengths = c(50, 50, 200, 300, 300), means = c(0, 1, 2, 3, 2.3), 
sds = rep(1, 5), seed = 123)
mbu <- multiscale.bottomUp(td$x)
plot(mbu, display = "data")
abline(v = td$cpts, col = 2, lwd = 2, lty = 2)

# visualise estimated piecewise constant signal by solid line
# and true signal by broken line
td <- testData("blocks", seed = 123)
mlp <- multiscale.localPrune(td$x)
plot(mlp, display = "data")
lines(td$mu, col = 2, lwd = 2, lty = 2)
}
\references{
P. Fryzlewicz (2014)
Wild Binary Segmentation for Multiple Change-Point Detection.
\emph{The Annals of Statistics}, Volume 42, Number 6, pp. 2243-2281.
}
