% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_prune.R
\name{summary.multiscale.cpts}
\alias{summary.multiscale.cpts}
\title{Summary of change points estimated by multiscale MOSUM procedure}
\usage{
\method{summary}{multiscale.cpts}(object, ...)
}
\arguments{
\item{object}{a \code{multiscale.cpts} object}

\item{...}{not in use}
}
\description{
Summary method for objects of class \code{multiscale.cpts}
}
\details{
Provide information about each estimated change point, 
including the bandwidths used for its detection, associated p-value and (scaled) jump size;
if \code{object$do.confint=TRUE}, end points of the pointwise and uniform confidence intervals
are also provided.
}
\examples{
x <- testData(model = "mix", seed = 12345)$x
mlp <- multiscale.localPrune(x, do.confint = TRUE)
summary(mlp)
}
