% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{varOS}
\alias{varOS}
\title{Variance of Order Statistics}
\usage{
varOS(r, n, dist = c("unif", "exp", "weibull", "tri", "topple"), ...)
}
\arguments{
\item{r}{rank(s) of the desired order statistic(s) (e.g., \code{1} for the smallest order statistic).}

\item{n}{sample size from which the order statistic is derived.}

\item{dist}{a character string specifying the name of a distribution. Supported values are:
\itemize{
  \item \code{"unif"}: Uniform distribution
  \item \code{"exp"}: Exponential distribution
  \item \code{"weibull"}: Weibull distribution
  \item \code{"tri"}: Triangular distribution
  \item \code{"topple"}: Topp-Leon distribution
}}

\item{...}{further arguments to be passed to \code{dist}.}
}
\value{
The variance of the \eqn{r}th order statistic.
}
\description{
This function computes the variance of order statistics for a given distribution.
}
\details{
This function computes the variance of the \eqn{r}th order statistic (\eqn{X_{r:n}})
for a given sample size (\code{n}) and distribution (\code{dist}). The variance is calculated using:
\deqn{\text{Var}(X_{r:n}) = \text{E}(X^2_{r:n}) - (\text{E}(X_{r:n}))^2}
}
\examples{
# Variance of the 3rd order statistic in a sample of size 10 from a uniform distribution
varOS(r = 3, n = 10, dist = "unif")

}
