% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mo_exp}
\alias{mo_exp}
\title{Moments Of Order Statistics from the Exponential Distribution}
\usage{
mo_exp(r, n, k = 1, mu = 0, sigma = 1)
}
\arguments{
\item{r}{rank(s) of the desired order statistic(s) (e.g., \code{1} for the smallest order statistic).}

\item{n}{sample size from which the order statistic is derived.}

\item{k}{order of the moment to compute (default is \code{1}).}

\item{mu}{location parameter of the exponential distribution (default is 0).}

\item{sigma}{scale parameter of the exponential distribution (default is 1).}
}
\value{
The \eqn{k}th moment of the \eqn{r}th order statistic from an exponential distribution.
}
\description{
This function computes the moments of order statistics from the exponential distribution.
}
\details{
The function calculates the \eqn{k}th moment using the following relationship:

\deqn{
\text{E}[X_{r:n}^k] = \frac{n!}{(r-1)!(n-r)!} \cdot \sum_{j=0}^{r-1} (-1)^j \binom{r-1}{j}
\frac{\Gamma(k+1)}{(n-r+j+1)^{k+1}}.
}

For non-standard exponential distributions with \eqn{\mu} and \eqn{\sigma} parameters,
the transformation \eqn{X^*=\mu + \sigma X} is used.
}
\examples{
# First moment (mean) of the 2nd order statistic from a sample of size 5
mo_exp(2, 5, k = 1, mu = 0, sigma = 1)

# Second moment of the 3rd order statistic from an exponential distribution
# with mu = 2 and sigma = 3
mo_exp(3, 7, k = 2, mu = 2, sigma = 3)

}
\references{
Ahsanullah, M., Nevzorov, V. B., & Shakil, M. (2013). \emph{An introduction to order statistics} (Vol. 8). Paris: Atlantis Press.
}
