% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationchange.R
\name{stationchange}
\alias{stationchange}
\title{Identify most recent station change}
\usage{
stationchange(
  data,
  type = "mort",
  ID,
  station,
  res.start = "auto",
  res.end = "auto",
  residences = "auto",
  singles = TRUE,
  drift = FALSE,
  ddd = NULL,
  units = NULL,
  from.station = NULL,
  to.station = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{a dataframe of residence events. Residence events must include
tag ID, location name, start time, and duration.}

\item{type}{the method used to generate the residence events. Options are
"mort", "actel", "glatos", "vtrack", or "manual". If "manual", then user
must specify \code{ID}, \code{station}, \code{res.start}, and \code{residences}.}

\item{ID}{a string of the name of the column in \code{data} that holds the tag or
sample IDs.}

\item{station}{a string of the name of the column in \code{data} that holds the
station name or receiver location.}

\item{res.start}{a string of the name of the column in \code{data} that holds the
start date and time. Must be specified and in POSIXt if \code{type="manual"}.}

\item{res.end}{a string of the name of the column in \code{data} that holds the
end date and time. Must be specified and in POSIXt or character in the format
YYYY-mm-dd HH:MM:SS if \code{type="manual"}.}

\item{residences}{a character string with the name of the column in \code{data}
that holds the duration of the residence events.}

\item{singles}{specifies if single detections (length of residence event = 0)
should be retained. Default is \code{TRUE}.}

\item{drift}{option to account for potential drifting in identifying
station changes.}

\item{ddd}{a dataframe of stations/locations where detected movement between
stations may be due to drifting of an expelled tag or dead animal.}

\item{units}{optional units of the duration of the residence events in \code{data}.
Required if \code{drift=TRUE}. Options are "auto", or "secs", "mins", "hours", "days",
or "weeks".}

\item{from.station}{a string of the name of the column in \code{ddd} that contains
the station/location names where drifting detections may start from. Must
be identical to the station/location names in \code{data}.}

\item{to.station}{a string of the name of the column in \code{ddd} that contains
the station/location names where drifting detections may move to. Must
be identical to the station/location names in \code{data}.}

\item{verbose}{option to display progress bar as function is run. Default
is TRUE.}
}
\value{
a dataframe with one row for each tag ID, including the date/time of
the residence start at the most recent station or location, the date/time of
the residence end, and duration of the residence event. All input data fields
(e.g., any name, location, or species information that was included with the
input data) will be retained.
}
\description{
Identify the most recent station or location change from passive
acoustic telemetry data.
}
\examples{
stn.change<-stationchange(data=events,type="mort",ID="ID",station="Station.Name",verbose=FALSE)
head(stn.change)
}
