% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationchange.R
\name{resmaxcml}
\alias{resmaxcml}
\title{Maximum cumulative residence duration}
\usage{
resmaxcml(
  data,
  ID,
  station,
  res.start,
  res.end,
  residences,
  units,
  stnchange,
  verbose = TRUE
)
}
\arguments{
\item{data}{a dataframe of residence events. Residence events must include
tag ID, location name, start time, and duration.}

\item{ID}{a string of the name of the column in \code{data} that holds the tag or
sample IDs.}

\item{station}{a string of the name of the column in \code{data} that holds the
station name or receiver location.}

\item{res.start}{a string of the name of the column in \code{data} that holds the
start date and time. Must be specified and in POSIXt if \code{type="manual"}.}

\item{res.end}{a string of the name of the column in \code{data} that holds the
end date and time. Must be specified and in POSIXt if \code{type="manual"}.}

\item{residences}{a character string with the name of the column in \code{data}
that holds the duration of the residence events.}

\item{units}{units of the duration of the residence events in \code{data}.}

\item{stnchange}{a dataframe with the start time and location of the most
recent station or location change. Must use the same column names as \code{data}.}

\item{verbose}{option to display progress bar as function is run. Default
is TRUE.}
}
\value{
a dataframe with the cumulative residence information for each
period where an animal was consecutively detected at a single station/location.
Records are only given for cumulative residences that occurred before the most
recent station/location change (i.e., the animal can be assumed to be alive).
}
\description{
Find the maximum duration that an animal spent at a single
station/location before a station change (i.e., the animal can be assumed
to be alive). Differs from \code{resmax} in that the duration is cumulative -
the time of residence events and intervals between residence events are all
included, provided there are no intervening residence events at other
stations/locations.
}
\examples{
# Identify most recent station change
station.change<-stationchange(data=events[events$ID=="A",],type="mort",
ID="ID",station="Station.Name",verbose=FALSE)

cumulative_events<-resmaxcml(data=events[events$ID=="A",],ID="ID",
station="Station.Name",res.start="ResidenceStart",res.end="ResidenceEnd",
residences="ResidenceLength.days",units="days",
stnchange=station.change,verbose=FALSE)
}
