% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mort.R
\name{infrequent}
\alias{infrequent}
\title{Identify potential mortalities from infrequent detections}
\usage{
infrequent(
  data,
  type = "mort",
  ID,
  station,
  res.start = "auto",
  res.end = "auto",
  residences = "auto",
  units = "auto",
  method,
  threshold,
  threshold.units = NULL,
  recent.period = NULL,
  recent.units = NULL,
  start = NULL,
  end = NULL,
  morts.prev = NULL,
  replace = FALSE,
  backwards = FALSE,
  ddd = NULL,
  from.station = NULL,
  to.station = NULL,
  drift.cutoff = NULL,
  drift.units = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{a dataframe of residence events. Residence events must include
tag ID, location name, start time, end time, and duration.}

\item{type}{the method used to generate the residence events. Options are
"mort", "actel", "glatos", "vtrack", or "manual". If "manual", then user
must specify \code{ID}, \code{station}, \code{res.start}, \code{res.end}, \code{residences}, and \code{units}.}

\item{ID}{a string of the name of the column in \code{data} that holds the tag or
sample IDs.}

\item{station}{a string of the name of the column in \code{data} that holds the
station name or receiver location.}

\item{res.start}{a string of the name of the column in \code{data} that holds the
start date and time. Must be specified and in POSIXt or character in the format
YYYY-mm-dd HH:MM:SS if \code{type="manual"}.}

\item{res.end}{a string of the name of the column in \code{data} that holds the
end date and time. Must be specified and in POSIXt or character in the format
YYYY-mm-dd HH:MM:SS if \code{type="manual"}.}

\item{residences}{residences a character string with the name of the column in \code{data}
that holds the duration of the residence events.}

\item{units}{Units of the duration of the residence events in \code{data}. Options are "secs",
"mins", "hours", "days", and "weeks".}

\item{method}{a character string of the threshold method. Options are "recent"
and "defined". If "recent", must specify \code{recent.period} and \code{recent.units}.
If "defined", must specify \code{start} and \code{end}.}

\item{threshold}{the minimum summed duration of residence events for an animal
to be considered alive. Units must be the same as the units of \code{residences}.}

\item{threshold.units}{the units of \code{threshold}. Options are "secs",
"mins", "hours", "days", and "weeks". If \code{NULL}, assumed to be the same as
\code{units}.}

\item{recent.period}{the length of the period of time in which an animal must
be detected longer than the \code{threshold} to be considered alive. The period
ends with the most recent detection of a given animal.}

\item{recent.units}{the units of recent.period. Options are "secs",
"mins", "hours", "days", and "weeks".}

\item{start}{character string with the start of the user-defined time period to search for infrequent
detections if \code{method="defined"}. Must be in the format
YYYY-mm-dd HH:MM:SS. The time zone is the same as \code{res.start} or
assumed to be UTC if no time zone is defined for \code{res.start}.}

\item{end}{character string with the end of the user-defined time period to search for infrequent
detections if \code{method="defined"}. Must be in the format
YYYY-mm-dd HH:MM:SS. The time zone is the same as \code{res.start} or
assumed to be UTC if no time zone is defined for \code{res.start}.}

\item{morts.prev}{a dataframe containing potential mortalities. The dataframe must
have the same columns and in the same order as \code{data}.}

\item{replace}{if \code{morts} specified and an animal with infrequent detections
is already in \code{morts}, the record in \code{morts} will be replaced if \code{TRUE}.
Default is \code{FALSE}.}

\item{backwards}{option to examine residence events prior to the one that was
flagged as a potential mortality. If prior residence events are at the same
station/location as the flagged event, the time of the potential mortality is shifted
earlier.}

\item{ddd}{an optional dataframe of stations/locations where detected movement between
stations may be due to drifting of an expelled tag or dead animal.}

\item{from.station}{a string of the name of the column in \code{ddd} that contains
the station/location names where drifting detections may start from. Must
be identical to the station/location names in \code{data}.}

\item{to.station}{a string of the name of the column in \code{ddd} that contains
the station/location names where drifting detections may move to. Must
be identical to the station/location names in \code{data}.}

\item{drift.cutoff}{the maximum allowable time difference between detections to be
considered a single residence event. Recommended to be the same as used
to generate residence events in \code{data}.}

\item{drift.units}{the units of the cutoff. Options are "secs", "mins", "hours",
"days", and "weeks". Recommended to be the same as used to generate
residence events in \code{data}.}

\item{verbose}{option to display updates and progress bars as
sub-functions are called and run. Default is TRUE.}
}
\value{
if \code{morts=NULL}, a dataframe with one row for each tag ID, including the date/time of
the residence start when the potential mortality or expelled tag was identified.
If \code{morts} is specified, any potential mortalities will be added to existing
\code{morts} dataframe. If \code{morts} is specified and \code{replace=TRUE}, then any
mortalities that are flagged by \code{infrequent()} and occurred at an earlier
time than those in \code{morts} will be replaced to the earlier date.
All input data fields
(e.g., any name, location, or species information that was included with the
input data) will be retained.
}
\description{
Identifies potential mortalities or expelled tags from infrequent
detections in passive acoustic telemetry data. Mortalities are identfied based
on a user-defined threshold and timeframe.
}
\details{
Example of \code{method="recent"}: if \code{threshold=10}, \code{threshold.units="mins"},
\code{recent.period=52} and \code{recent.units="weeks"} (1 year), an animal will be
flagged as a potential mortality if it was detected for less than 10 minutes
within a year, ending with the most recent detection.

Example of \code{method="defined"}: if \code{threshold=10}, \code{threshold.units="mins"},
\code{start="2019-10-01"}, and \code{end="2020-06-01"}, an animal
will be flagged as a potential mortality if it was detected for less than 10
minutes between 01 October 2019 and 01 June 2020.
}
\examples{
## Recent example
inf_recent<-infrequent(data=events,type="mort",ID="ID",
station="Station.Name",method="recent",
threshold=72,threshold.units="hours",
recent.period=52,recent.units="weeks",
verbose=FALSE)
head(inf_recent)

## User-defined example
inf_defined<-infrequent(data=events,type="mort",ID="ID",
station="Station.Name",method="defined",
threshold=12,threshold.units="hours",
start="2006-06-15",end="2006-10-15",
verbose=FALSE)
head(inf_defined)
}
