% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representativity.R
\name{lt.representativity}
\alias{lt.representativity}
\title{Checks the representativity of the non-adult age groups in a mortAAR
life table}
\usage{
lt.representativity(life_table)
}
\arguments{
\item{life_table}{an object of class mortaar_life_table.}
}
\value{
data.frame showing the indices and explaining their interpretation.
}
\description{
\emph{Weiss 1973}, 46f. and \emph{Bocquet-Appel and Masset 1977} (see also
\emph{Herrmann et al. 1990}, 306f.) have devised indices which check
if the non-adult age groups are represented in proportions as can be
expected from modern comparable data. Whether this is really applicable
to archaeological data-sets is a matter of debate.\cr
Quite recently, \emph{Taylor and Oxenham 2024} added a comparison of Total
fertility rates (TRF) according to different formulas which depend either
on subadults or adults.\cr
Weiss chose the mortality (qx) as deciding factor and claimed that
(1) the probability of death of the age group 10--15 (5q10)
should be lower than that of the group 15--20 (5q15) and that (2)
the latter in turn should be lower than that of age group 0--5
(5q0).\cr
In contrast, Bocquet-Appel and Masset took the raw number of dead (Dx)
and asserted that (1) the ratio of those having died between 5 and 10
(5D5) to those having died between 10 and 15 (5D15) should be equal or
larger than 2 and that (2) the ratio of those having died between 5 and 15
(10D5) and all adults (>= 20) should be 0.1 or larger.\cr
The formualas Taylor and Oxenham used either weigh all individuals aged 0--14
against all individuals or all individuals aged 15--49 against all individuals
aged 15+. The formulas differ from the original ones published by
\emph{McFadden and Oxenham 2018} and \emph{Taylor et al. 2023} because the
data basis is slighty different. If the results of the formulas deviate
by more than 0.692 (the standard error of estimate, SEE), there is a problem
with the age structure.\cr
Due to the specific nature of the indices, they only give meaningful
results if 5-year-age categories have been chosen for the non-adults.
}
\examples{
schleswig <- life.table(schleswig_ma[c("a", "Dx")])
lt.representativity(schleswig)

}
\references{
\insertRef{herrmann_prahistorische_1990}{mortAAR}

\insertRef{masset_bocquet_1977}{mortAAR}

mcfadden_oxenham_2018a

\insertRef{weiss_demography_1973}{mortAAR}

\insertRef{taylor_oxenham_2024}{mortAAR}
taylor_et_al_2023
}
