% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-SurvFitVarExp.R
\name{SurvIT_var}
\alias{SurvIT_var}
\title{Internal predict function}
\usage{
SurvIT_var(
  Cw,
  time,
  kd,
  hb,
  alpha,
  beta,
  interpolate_length = NULL,
  interpolate_method = c("linear", "constant")
)
}
\arguments{
\item{Cw}{A vector of external concentration}

\item{time}{A vector of time}

\item{kd}{a vector of parameter}

\item{hb}{a vector of parameter}

\item{alpha}{a vector of parameter}

\item{beta}{a vector of parameter}

\item{interpolate_length}{if \code{display.time} is \code{NULL}, the argument
\code{interpolate_length} can be used to provide a sequence from 0 to maximum of
the time of exposure in original dataset (used for fitting).}

\item{interpolate_method}{The interpolation method for concentration.
See package \code{deSolve} for details.}
}
\value{
A data.frame with exposure columns \code{time} and \code{conc} and
the resulting probabilisty of survival in \code{Psurv_XX} column where
\code{XX} refer to an MCMC iteration
}
\description{
Survival function for "IT" model with external concentration changing
with time
}
