# morseTKTD <img src="morseTKTD-logo.png" align="right" height="139" />

Advanced methods for a valuable quantitative environmental risk assessment using
Bayesian inference of Survival TKTD models (like the Generalized Unified
Threshold model of Survival (GUTS)).

## Submission

Before a submission, you can look at [prepare-for-cran](https://github.com/ThinkR-open/prepare-for-cran)
, which is an open and collaborative list of things you have to check before 
submitting your package to the CRAN.

Otherwise, check "as-cran"" using the source package:
```
library(devtools)
# create documentation
devtools::document(roclets = c('rd', 'collate', 'namespace'))
```

Once the archive is done, check that .Rbuildignore was applied.
Try to have a low size archive (< 2Mb)

Either directly
```R
# build and check the archive
devtools::check()
```

Or in 2 steps:

```
# 1. build the package. 
devtools::build()
# 2. check the archive. 
devtools::check_built("../morseTKTD_0.1.0.tar.gz")
```

See the CRAN status of your sumbmission:
- incoming R CRAN packages: [Index of /incoming](https://cran.r-project.org/incoming/)
- incoming dashboard: [incoming dashboard](https://r-hub.github.io/cransays/articles/dashboard.html)

## Install from gitlab repository

```R
library('remotes')
remotes::install_gitlab("mosaic-software/morsetktd", host = "gitlab.in2p3.fr")
```

## Build the manual and vignettes

```R
library('devtools')
devtools::document(roclets = c('rd', 'collate', 'namespace'))
devtools::build_manual()
devtools::build_vignettes()
```

## building the package

#### Note add to .buildignore

```R
# remove files .rds in fixtures
rds_files <- list.files(path = "tests/testthat/fixtures", pattern = "\.rds$", full.names = TRUE)
use_build_ignore(rds_files, escape = TRUE)
```

```R
library(devtools)
devtools::build()
```

## Add dependencies

```R
usethis::use_package("ggplot2")
```

## Coverage

From R session

```R
library(covr)
cov <- package_coverage("morseTKTD")
```

# Style of process

## The succession of steps

1. `data`: load the data set.
2. `BinaryData`, `CountData` or `ContinuousData`: make a `ModelData` object for binary, count and quantitative continuous data, respectively. 
3. The above-mentioned objects inherit of `data.frame`
4. `plot`: plot a `ModelData` object.
5. `summary`: provides a summary of a `ModelData` object. 
7. `doseResponse`: return a `DoseResponse` object.
8. `plot`: plot a `DoseResponse` object.
8. `fit`: fit a `ModelData` object and return a `Fit` object.
9. `plot`: plot a `Fit` object.
10. `ppc`: return a `PPC` object.
11. `plot`: plot a `PPC` object.


## Coding Style

Object: `BigCamelCase`

```R
class(x) <- append("ObjectCamelCase", class(x))
```

Methods: `small_snake_case`

```R
methods_snake_case <- function(object, ...){
  UseMethod("methods_snake_case")
}
```

```R
methods_snake_case.ObjectCamelCase <- function(...){}
```

Function (no methods - not linked to object): `smallCamelCase`

```R
smallCamelCase <- function(...){}
```
