% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/out_range.R
\name{out_range}
\alias{out_range}
\title{Detect values outside ranges of reference conditions}
\usage{
out_range(m_matrix, g_matrix, type = "basic")
}
\arguments{
\item{m_matrix}{matrix of variables representing the set of conditions to be
used as reference. Each column represents a variable.}

\item{g_matrix}{matrix of variables representing the set of conditions to be
compared against the reference conditions (where conditions outside range
are to be detected). Each column represents a variable. Variable names must
match those in \code{m_matrix}.}

\item{type}{\code{character}, type of identification to be performed. See \code{Details}
for options.}
}
\value{
A list containing the ranges in \code{m_matrix}, results from analysis
according to \code{type}, and table to help with interpretations. NA values
represent conditions of interest inside ranges of reference conditions.
See \code{Details}.
}
\description{
Options to identify which values in a set of conditions of interest
(\code{g_matrix}) are outside the range of a set of conditions of
reference (\code{m_matrix}).
}
\details{
Results are produced according to \code{type}:
\itemize{
\item \strong{basic} - helps to identify conditions outside ranges, in general, one or
variables are only counted as \code{1}. This is always returned.
\item \strong{simple} - identifies the number of variables with conditions outside
ranges, for each condition of interest outside ranges, the number of
non-analogous variables is returned.
\item \strong{detailed} - produces various results (including the two above):
\itemize{
\item \emph{high_all} - identifies non-analogous conditions towards high values of
variables, for each variable independently.
\item \emph{low_all} - identifies non-analogous conditions towards low values of
variables, for each variable independently.
\item \emph{high_combined} - values are used to identify combinations of variables
with non-analogous conditions towards high values of the variables.
\item \emph{low_combined} - values are used to identify combinations of variables
with non-analogous conditions towards low values of the variables.
\item \emph{interpretation} - a \code{data.frame} to help identify which variables are
considered in combined results.
}
}
}
\examples{
# data
data("reference_matrix", package = "mop")
data("matrix_of_interest", package = "mop")

# analysis
out <- out_range(m_matrix = reference_matrix,
                 g_matrix = matrix_of_interest)
}
