% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moose.R
\name{moose}
\alias{moose}
\title{moose: mean squared out-of-sample error projection}
\usage{
moose(reg, dataset)
}
\arguments{
\item{reg}{an lm object containing the regression to project out-of-sample}

\item{dataset}{a data.frame containing new cases for out-of-sample projection}
}
\description{
This function projects the mean squared out-of-sample error for a linear regression
}
\examples{
# set the seed for reproducibility of the example
set.seed(04251978)
# randomly generate 100 observations of data
mydata <- data.frame(x1=rnorm(100),x2=rnorm(100),x3=rnorm(100))
# true outcome variable is y = x1 + x2 + x3 + e
y <- mydata$x1 + mydata$x2 + mydata$x3 + rnorm(100)
# regression with the first 25 observations from the dataset
reg <- lm(y ~ x1 + x2 + x3,data=cbind(y,mydata)[1:25,])
# using the predictor values from the first 25 observations,
# project the out-of-sample error we can expect in the case of
# "non-stochastic" predictors whose values are the same in the
# test sample as in the training sample.
# note that mydata does not include the outcome variable.
same.predictor.values.error <- moose(reg,mydata[1:25,])
# by comparison, the in-sample R-squared value observed
# in training is:
summary(reg)$r.squared
# using the predictor values from the next 75 obsevervations,
# project the out-of-sample error we can expect in the case
# of stochastic predictors whose values potentially differ
# from those used in training.
new.predictor.values.error <- moose(reg,mydata[26:100,])
# by comparison, the actual mse and out-of-sample R-squared value
# obtained from observations 26-100 of this random sample are:
mse <- mean((y[26:100]-predict(reg,mydata[26:100,]))^2)
mse
m.total.sqs <- mean((y[26:100]-mean(y[26:100]))^2)
r2o <- 1-mse/m.total.sqs
r2o
}
\keyword{generalization}
\value{
	\item{mse}{Projected mean squared out-of-sample error}
	\item{R2o}{Projected out-of-sample R-squared}
	\item{hat}{Leverage for each out-of-sample observation. For each i, this is the sum of the squared elements of xi [X'X]^-1 X', where X is the predictor matrix from the training sample.}
}