% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compressMytable.R
\name{compress}
\alias{compress}
\alias{compress.mytable}
\alias{compress.cbind.mytable}
\alias{compress.data.frame}
\title{Compress an object of class mytable or cbind.mytable}
\usage{
compress(x, no = 2, add.label = TRUE)

\method{compress}{mytable}(x, no = 2, add.label = TRUE)

\method{compress}{cbind.mytable}(x, no = 2, add.label = TRUE)

\method{compress}{data.frame}(x, no = 2, add.label = TRUE)
}
\arguments{
\item{x}{An object of class mytable or cbind.mytable}

\item{no}{Representative group of two groups}

\item{add.label}{Logical. Whether or not add representative group name}
}
\description{
Compress an object of class mytable or cbind.mytable
}
\section{Methods (by class)}{
\itemize{
\item \code{mytable}: S3 method for class mytable

\item \code{cbind.mytable}: S3 method for class cbind.mytable

\item \code{data.frame}: S3 method for class data.frame
}}

\examples{
require(stringr)
require(magrittr)
mytable(acs) \%>\% compress
mytable(Dx~.,data=acs) \%>\% compress
\dontrun{
require(ztable)
mytable(Dx~.,data=acs) \%>\% compress \%>\% ztable
mytable(Dx+sex~.,data=acs) \%>\% compress
}
}
