% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdl_grades.R
\name{mdl_grades}
\alias{mdl_grades}
\title{Get Grades}
\usage{
mdl_grades(con = mdl_get_connection(), tbl_prefix = "mdl_")
}
\arguments{
\item{con}{database connection object}

\item{tbl_prefix}{table prefix}
}
\value{
A dbplyr reference object
}
\description{
Returns a reference to the (cached) grades table, with the most relevant columns selected.
}
\examples{
\dontrun{
# Get the course grades for courseid 52
course_grades <- mdl_grades() \%>\%
filter(courseid == 52, item_type == "course") \%>\%
collect()
# Get the other grades items:
grades_items_grades <- mdl_grades() \%>\%
filter(courseid == 52, item_type != "course") \%>\%
collect()
}
}
