% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_category_definition.R
\name{define_questions_from_excel}
\alias{define_questions_from_excel}
\alias{define_questions_from_excel.question_category}
\title{Define questions from a Excel file}
\usage{
define_questions_from_excel(qc, file, sheet_index, sheet_name)

\method{define_questions_from_excel}{question_category}(qc, file, sheet_index = NULL, sheet_name = NULL)
}
\arguments{
\item{qc}{A \code{question_category} object.}

\item{file}{A string, name of an Excel file.}

\item{sheet_index}{A number, sheet index in the workbook.}

\item{sheet_name}{A string, sheet name.}
}
\value{
A \code{question_category}.
}
\description{
Each row in the Excel file is interpreted as a question. We only have to define
the columns that we are going to use, the rest of the columns are taken by default.
}
\details{
In addition to the file, we can indicate the sheet by its name or index. If we
do not indicate anything, it considers the first sheet.

For answers where a vector is required, "<|>" is used as a separator of the vector
elements.
}
\examples{

\donttest{
file <- system.file("extdata", "questions.xlsx", package = "moodef")
qc <-
  question_category(category = 'Initial test', adapt_images = TRUE) |>
  define_questions_from_excel(file = file)
}

}
\seealso{
Other question definition functions: 
\code{\link{define_extended_question}()},
\code{\link{define_question}()},
\code{\link{define_questions_from_csv}()},
\code{\link{define_questions_from_data_frame}()},
\code{\link{generate_xml}()},
\code{\link{generate_xml_file}()},
\code{\link{question_category}()}
}
\concept{question definition functions}
