% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plotCoefs}
\alias{plotCoefs}
\title{Plot model coefficients with confidence intervals}
\usage{
plotCoefs(
  fit,
  true = FALSE,
  alpha = 0.05,
  plot = TRUE,
  col = "blue",
  flip = TRUE,
  data = NULL,
  select = TRUE,
  size = 1,
  labels = TRUE,
  title = NULL,
  vars = "all"
)
}
\arguments{
\item{fit}{Output from \code{\link{fitNetwork}}, \code{\link{bootNet}}, or
\code{\link{resample}}. Can also be the \code{fixedNets} or
\code{betweenNet} elements of the \code{\link{mlGVAR}} output.}

\item{true}{An adjacency matrix containing the true parameter values, if
known. This can be used in conjunction with a simulated network, in that
the user can supply the true network and plot those values against the
estimated values.}

\item{alpha}{Alpha level that is used to compute confidence intervals.}

\item{plot}{Logical. If \code{FALSE}, a dataframe containing all of the
confidence interval data will be returned.}

\item{col}{Character string. Color of the points associated with the
\code{true} values.}

\item{flip}{Logical. If \code{FALSE}, the facets will be turned 90 degrees.}

\item{data}{Supply the original dataset if not already included in the
\code{fit} object.}

\item{select}{Relevant to the \code{\link{resample}} output. Determines
whether all variables should be plotted, or only those that were selected
according to the resampling or variable selection procedure.}

\item{size}{Numeric. Size of the point estimates.}

\item{labels}{If logical, determines whether or not variable labels should be
included. If a character vector, can be used to customize variable labels.}

\item{title}{Custom plot title.}

\item{vars}{Defaults to \code{"all"}. Determines which variables should be
plotted.}
}
\value{
Plot displaying estimated model coefficients and confidence
intervals.
}
\description{
Return a plot or dataframe showing the point estimates from each model, along
with confidence intervals based on the estimated standard errors.
}
\details{
This is differentiated from the output of \code{\link{bootNet}} and
\code{\link{plotBoot}} in that the confidence intervals are computed directly
from model parameters rather than estimated from bootstrapping.
}
\examples{
\donttest{
x <- fitNetwork(ggmDat)
plot(x, which.net = 'coefs')
plotCoefs(x) # This is the same as the above command
}
}
\seealso{
\code{\link{fitNetwork}, \link{resample}, \link{getFitCIs},
  \link{plot.resample}, \link{plotNet}}
}
