% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbsmk.R
\name{bbsmk}
\alias{bbsmk}
\title{Nonparametric Block Bootstrapped Mann-Kendall Trend Test}
\usage{
bbsmk(x, ci=0.95, nsim=2000, eta=1, bl.len=NULL)
}
\arguments{
\item{x}{- Time series data vector}

\item{ci}{- Confidence interval}

\item{nsim}{- Number of bootstrapped simulations}

\item{eta}{- Added to the block length}

\item{bl.len}{- Block length}
}
\value{
Z-Value  - Mann-Kendall Z statistic

Sen's slope - Sen's trend slope

S - Mann-Kendall S statistic

Tau  - Mann-Kendall's Tau value

Kendall's Tau Empirical Bootstrapped CI - Kendall's Tau empirical bootstrapped confidence interval

Z-value Empirical Bootstrapped CI - Z-value empirical bootstrapped confidence interval
}
\description{
Significant serial correlation present in time series data can be accounted for using the nonparametric block bootstrap technique, which incorporates the Mann-Kendall trend test (Mann, 1945; Kendall, 1975; Kundzewicz and Robson, 2000).  Predetermined block lengths are used in resampling the original time series, thus retaining the memory structure of the data.  If the value of the test statistic falls in the tails of the empirical bootstrapped distribution, there is likely a trend in the data.  The block bootstrap technique is powerful in the presence of autocorrelation (Khaliq et al. 2009; Önöz and Bayazit, 2012).
}
\details{
Block lengths are automatically selected using the number of contiguous significant serial correlations, to which the eta (\eqn{\eta}) term is added. A value of \eqn{\eta = 1} is used as the default as per Khaliq et al. (2009).  Alternatively, the user may define the block length.  2000 bootstrap replicates are recommended as per Svensson et al. (2005) and Önöz, B. and Bayazit (2012).
}
\examples{
x<-c(Nile[1:10])
bbsmk(x)

}
\references{
Box, G. E. P. and Jenkins, G. M. (1970). Time Series Analysis Forecasting and Control. Holden-Day, San Fransisco, California, 712 pp.

Kendall, M. (1975). Rank Correlation Methods. Griffin, London, 202 pp.

Khaliq, M. N., Ouarda, T. B. M. J., Gachon, P., Sushama, L., and St-Hilaire, A. (2009). Identification of hydrological trends in the presence of serial and cross correlations: A review of selected methods and their application to annual flow regimes of Canadian rivers. Journal of Hydrology, 368: 117-130.

Kundzewicz, Z. W. and Robson, A. J. (2000). Detecting Trend and Other Changes in Hydrological Data. World Climate Program-Data and Monitoring. World Meteorological Organization, Geneva  (WMO/TD-No. 1013).

Kundzewicz, Z. W. and Robson, A. J. (2004). Change detection in hydrological records-A review of the methodology. Hydrological Sciences Journal, 49(1): 7-19.

Mann, H. B. (1945). Nonparametric Tests Against Trend. Econometrica, 13(3): 245-259.

Önöz , B. and Bayazit M. (2012). Block bootstrap for Mann-Kendall trend test of serially dependent data. Hydrological Processes, 26: 3552-3560.

Svensson, C., Kundzewicz, Z. W., and Maurer, T. (2005). Trend detection in river flow series: 2. Floods and low-flow index series. Hydrological Sciences Journal, 50(5): 811-823.
}
