% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distr_plots.R
\name{distr_plots}
\alias{distr_plots}
\title{Plots distribution of original and simulated data}
\usage{
distr_plots(
  Modgo_obj,
  variables = colnames(Modgo_obj[["original_data"]]),
  sim_dataset = 1,
  wespalette = "Cavalcanti1",
  text_size = 12
)
}
\arguments{
\item{Modgo_obj}{An object returned by \code{\link[modgo]{modgo}}.}

\item{variables}{A character vector indicating the columns in the data to 
be used in plots.}

\item{sim_dataset}{Number indicating the simulated dataset in 
\code{Modgo_obj} to be used in plots.}

\item{wespalette}{a name of the selected wesanderson color pallet}

\item{text_size}{a number for the  size of the annotation text}
}
\value{
A ggplot object depicting distribution of different variables.
}
\description{
Produces a graphical display of the distribution of the variables
of the original dataset and a single simulated dataset for an object 
returned by \code{\link[modgo]{modgo}}.
}
\details{
For continuous variables box-and-whisker plots are displayed, while 
categorical variables bar charts are produced.
}
\examples{
data("Cleveland",package="modgo")
test_modgo <- modgo(data = Cleveland,
     bin_variables = c("CAD","HighFastBloodSugar","Sex","ExInducedAngina"),
     categ_variables =c("Chestpaintype"))

distr_plots(test_modgo)

}
\author{
Andreas Ziegler, Francisco M. Ojeda, George Koliopanos
}
