% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_sd.R
\name{pop_sd}
\alias{pop_sd}
\title{Calculate Population Standard Deviation}
\usage{
pop_sd(x)
}
\arguments{
\item{x}{A numeric vector for which the population standard deviation should be calculated.}
}
\value{
A numeric value representing the population standard deviation of the vector.
}
\description{
This function calculates the population standard deviation for a numeric vector.
}
\examples{
# Example usage:
library(dplyr)
df <- data.frame(weight = c(2, 4, 6, 8, 10))
df |> 
  summarize(population_mean = mean(weight), 
            population_sd = pop_sd(weight))

}
