% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/building_complaints.R
\name{data_building_complaints}
\alias{data_building_complaints}
\title{NYC Building Complaints}
\source{
\url{https://data.cityofnewyork.us/Housing-Development/DOB-Complaints-Received/eabe-havv/about_data}
}
\usage{
data_building_complaints(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link[pins:pin_read]{pins::pin_read()}}.}
}
\value{
tibble
}
\description{
A subset of the complaints received by the Department of Buildings (DOB) in New York City, USA.
}
\details{
A data frame with 4,234 rows and 11 columns:
\describe{
\item{days_to_disposition}{Days to disposition of the complaint}
\item{status}{Status of the complaint}
\item{year_entered}{Year the complaint was entered}
\item{latitude, longitude}{Geographic coordinates}
\item{borough}{Borough}
\item{special_district}{Special district}
\item{unit}{Unit dispositioning the complaint}
\item{community_board}{Community board. 3-digit identifier: Borough code = first position, last 2 = community board}
\item{complaint_category}{Complaint category}
\item{complaint_priority}{Complaint priority}
}
}
\section{tibble print}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{data_building_complaints()
#> # A tibble: 4,234 x 11
#>    days_to_disposition status year_entered latitude longitude borough 
#>                  <dbl> <chr>  <fct>           <dbl>     <dbl> <fct>   
#>  1                  72 ACTIVE 2023             40.7     -74.0 Brooklyn
#>  2                   1 ACTIVE 2023             40.6     -74.0 Brooklyn
#>  3                  41 ACTIVE 2023             40.7     -73.9 Queens  
#>  4                  45 ACTIVE 2023             40.7     -73.8 Queens  
#>  5                  16 ACTIVE 2023             40.6     -74.0 Brooklyn
#>  6                  62 ACTIVE 2023             40.7     -73.8 Queens  
#>  7                  56 ACTIVE 2023             40.7     -74.0 Brooklyn
#>  8                  11 ACTIVE 2023             40.7     -74.0 Brooklyn
#>  9                  35 ACTIVE 2023             40.7     -73.8 Queens  
#> 10                  38 ACTIVE 2023             40.7     -73.9 Queens  
#> # i 4,224 more rows
#> # i 5 more variables: special_district <fct>, unit <fct>,
#> #   community_board <fct>, complaint_category <fct>, complaint_priority <fct>
}\if{html}{\out{</div>}}
}

\section{glimpse()}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{tibble::glimpse(data_building_complaints())
#> Rows: 4,234
#> Columns: 11
#> $ days_to_disposition <dbl> 72, 1, 41, 45, 16, 62, 56, 11, 35, 38, 39, 106, 1,~
#> $ status              <chr> "ACTIVE", "ACTIVE", "ACTIVE", "ACTIVE", "ACTIVE", ~
#> $ year_entered        <fct> 2023, 2023, 2023, 2023, 2023, 2023, 2023, 2023, 20~
#> $ latitude            <dbl> 40.66173, 40.57668, 40.73242, 40.68245, 40.63156, ~
#> $ longitude           <dbl> -73.98297, -74.00453, -73.87630, -73.79367, -73.99~
#> $ borough             <fct> Brooklyn, Brooklyn, Queens, Queens, Brooklyn, Quee~
#> $ special_district    <fct> None, None, None, None, None, None, None, None, No~
#> $ unit                <fct> Q-L, Q-L, SPOPS, Q-L, BKLYN, Q-L, Q-L, SPOPS, Q-L,~
#> $ community_board     <fct> 307, 313, 404, 412, 312, 406, 306, 306, 409, 404, ~
#> $ complaint_category  <fct> 45, 45, 49, 45, 31, 45, 45, 49, 45, 45, 45, 4A, 31~
#> $ complaint_priority  <fct> B, B, C, B, C, B, B, C, B, B, B, B, C, C, B, B, B,~
}\if{html}{\out{</div>}}
}

\examples{
\donttest{
data_building_complaints()
}
}
