% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{module}
\alias{module}
\alias{ule}
\alias{acquire}
\title{Make a Module}
\usage{
module(..., parent = parent.frame(), lock = TRUE,
  expose_private = FALSE)

ule(..., parent = parent.frame(), lock = TRUE,
  expose_private = FALSE)

acquire(module, parent = baseenv(), lock = TRUE,
  expose_private = FALSE)
}
\arguments{
\item{...}{module expression}

\item{parent}{the enclosing environment}

\item{lock}{lock the environment; logical}

\item{expose_private}{expose the private environment as `..private..`; logical}

\item{module}{module object, or path to a module file}
}
\value{
an \code{environment} of class \code{module} containing defined objects
}
\description{
Institute a module object inline or from a file.
mod::ule() is a useful shorthand for module() when this package is not attached.
}
\examples{

# from file
module_path <- system.file("misc", "example_module.R", package = "mod")
example_module <- acquire(module_path)

example_module$e(123)

# inline
my_module <- mod::ule({
    a <- 1
    .a <- 2
    f <- function(){.a}
})

my_module$a
my_module$f

}
