% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAC_spatial.R
\name{spec_sample}
\alias{spec_sample}
\title{Sample species richness}
\usage{
spec_sample(abund_vec, n)
}
\arguments{
\item{abund_vec}{Species abundance distribution of the community (integer vector)}

\item{n}{Sample size in terms of number of individuals (integer)}
}
\value{
Expected number of species in a sample of n individuals
}
\description{
Expected species richness in a random sample of fixed size.
}
\details{
The expected number of species is calculated after Hurlbert 1971, Equation 3.

\code{spec_sample} is similar to the function \code{\link[vegan]{rarefy}}
in the R package \code{\link[vegan]{vegan}}.
}
\examples{
sad1 <- sim_sad(100, 1000)
spec_sample(abund_vec = sad1, n = 20)

}
\references{
Hurlbert, S.H. 1971. The nonconcept of species diversity: a critique and +
alternative parameters. Ecology 52, 577-586.
}
