% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{MASkew}
\alias{MASkew}
\title{multivariate skewness in the sense of Malkovich and Afifi}
\usage{
MASkew(data, Points = NULL)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{Points}{points for approximation of the maximum on the sphere. \code{Points=NULL} generates 1000 uniformly distributed Points on the d dimensional unit sphere.}
}
\value{
value of sample skewness in the sense of Malkovich and Afifi.
}
\description{
This function computes the invariant measure of multivariate sample skewness due to Malkovich and Afifi (1973).
}
\details{
Multivariate sample skewness due to Malkovich and Afifi (1973) is defined by
\deqn{b_{n,d,M}^{(1)}=\max_{u\in \{x\in\mathbf{R}^d:\|x\|=1\}}\frac{\left(\frac{1}{n}\sum_{j=1}^n(u^\top X_j-u^\top \overline{X}_n )^3\right)^2}{(u^\top S_n u)^3},}
where \eqn{\overline{X}_n} is the sample mean and \eqn{S_n} is the sample covariance matrix of the random vectors \eqn{X_1,\ldots,X_n}. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the function returns an error.
}
\examples{
MASkew(MASS::mvrnorm(50,c(0,1),diag(1,2)))

}
\references{
Malkovich, J.F., and Afifi, A.A. (1973), On tests for multivariate normality, J. Amer. Statist. Ass., 68:176–179.

Henze, N. (2002), Invariant tests for multivariate normality: a critical review, Statistical Papers, 43:467–506.
}
