% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kenwardroger.R
\name{h_get_kr_comp}
\alias{h_get_kr_comp}
\title{Obtain Kenward-Roger Adjustment Components}
\usage{
h_get_kr_comp(tmb_data, theta)
}
\arguments{
\item{tmb_data}{(\code{mmrm_tmb_data})\cr produced by \code{\link[=h_mmrm_tmb_data]{h_mmrm_tmb_data()}}.}

\item{theta}{(\code{numeric})\cr theta estimate.}
}
\value{
Named list with elements:
\itemize{
\item \code{P}: \code{matrix} of \eqn{P} component.
\item \code{Q}: \code{matrix} of \eqn{Q} component.
\item \code{R}: \code{matrix} of \eqn{R} component.
}
}
\description{
Obtains the components needed downstream for the computation of Kenward-Roger degrees of freedom.
Used in \code{\link[=mmrm]{mmrm()}} fitting if method is "Kenward-Roger".
}
\details{
the function returns a named list, \eqn{P}, \eqn{Q} and \eqn{R}, which corresponds to the
paper in 1997. The matrices are stacked in columns so that \eqn{P}, \eqn{Q} and \eqn{R} has the same
column number(number of beta parameters). The number of rows, is dependent on
the total number of theta and number of groups, if the fit is a grouped mmrm.
For \eqn{P} matrix, it is stacked sequentially. For \eqn{Q} and \eqn{R} matrix, it is stacked so
that the \eqn{Q_{ij}} and \eqn{R_{ij}} is stacked from \eqn{j} then to \eqn{i}, i.e. \eqn{R_{i1}}, \eqn{R_{i2}}, etc.
\eqn{Q} and \eqn{R} only contains intra-group results and inter-group results should be all zero matrices
so they are not stacked in the result.
}
\keyword{internal}
