% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesFeature.R
\name{sampleToBayesFeatures}
\alias{sampleToBayesFeatures}
\title{Transform an entire sample into a collection of Bayesian features.}
\usage{
sampleToBayesFeatures(dfRow, targetCol)
}
\arguments{
\item{dfRow}{a row of a data.frame with a value for each feature.}

\item{targetCol}{the name of the feature (column in the data.frame)
that is the target variable for classification or regression.}
}
\value{
a data.frame where the first row is the feature that
represents the label.
}
\description{
Helper function that takes one sample (e.g., a row of a dataframe
with validation data) and transforms it into a data.frame where
each row corresponds to one feature (and its value) of the sample.
This is done using @seealso \code{createFeatureForBayes}. This
operation can be thought of transposing a matrix.
}
\examples{
# Converts all features of iris; the result is a data.frame of length
# equal to the amount of features in iris (5). The first feature is
# targetCol (has isLabel=TRUE).
samp <- mmb::sampleToBayesFeatures(dfRow = iris[15,], targetCol = "Species")
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
\keyword{feature}
