% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesNeighborhood.R
\name{centralities}
\alias{centralities}
\title{Given a neighborhood of data, computes the similarity of each sample
in the neighborhood to the neighborhood.}
\usage{
centralities(
  dfNeighborhood,
  selectedFeatureNames = c(),
  shiftAmount = 0.1,
  doEcdf = FALSE,
  ecdfMinusOne = FALSE
)
}
\arguments{
\item{dfNeighborhood}{data.frame that holds all rows that make up the neighborhood.}

\item{selectedFeatureNames}{vector of names of features to use. The centrality
of each row in the neighborhood is calculated based on the selected features.}

\item{shiftAmount}{numeric DEFAULT 0.1 optional amount to shift each features
probability by. This is useful for when the centrality not necessarily must be
an actual probability and too many features are selected. To obtain actual
probabilities, this needs to be 0, and you must use the ECDF.}

\item{doEcdf}{boolean DEFAULT FALSE whether to use the ECDF instead of the EPDF
to find the likelihood of continuous values.}

\item{ecdfMinusOne}{boolean DEFAULT FALSE only has an effect if the ECDF is
used. If true, uses 1 minus the ECDF to find the probability of a continuous
value. Depending on the interpretation of what you try to do, this may be of use.}
}
\value{
a named vector, where the names correspond to the rownames of the rows
in the given neighborhood, and the value is the centrality of that row.
}
\description{
Takes a data.frame of samples, then builds a PDF/PMF or ECDF
for each of the selected features. Then, for each sample, computes the product
of probabilities. The result is a vector that holds a probability for each
sample. That probability (or relative likelihood) then represents the
vicinity (or similarity) of the sample to the given neighborhood.
}
\examples{
# Create a neighborhood:
nbh <- mmb::neighborhood(df = iris, features = mmb::createFeatureForBayes(
  name = "Sepal.Width", value = mean(iris$Sepal.Width)))

cent <- mmb::centralities(dfNeighborhood = nbh, shiftAmount = 0.1,
  doEcdf = TRUE, ecdfMinusOne = TRUE)

# Plot the ordered samples to get an idea of the centralities in the neighborhood:
plot(x = names(cent), y=cent)
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
\keyword{network}
