% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesFeature.R
\name{bayesFeaturesToSample}
\alias{bayesFeaturesToSample}
\title{Transform a collection of Bayesian features back to a sample.}
\usage{
bayesFeaturesToSample(dfOrg, features)
}
\arguments{
\item{dfOrg}{data.frame containing at least one row of the original
format, so that we can rebuild the sample matching exactly the
original column names.}

\item{features}{data.frame of Bayes-features, as for example
previously created using \code{mmb::sampleToBayesFeatures()}.}
}
\value{
data.frame the sample as 1-row data.frame.
}
\description{
Counter operation to @seealso \code{mmb::sampleToBayesFeatures()}.
Takes a Bayes-feature data.frame and transforms it back to a row.
}
\examples{
samp <- mmb::sampleToBayesFeatures(dfRow = iris[15,], targetCol = "Species")

# Convert the sample (as features) back to a sample that can be, e.g.,
# appended to the data again:
row <- mmb::bayesFeaturesToSample(dfOrg = iris, features = samp)
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
\keyword{feature}
