% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesCaret.R
\docType{data}
\name{bayesCaret}
\alias{bayesCaret}
\title{Provides a caret-compatible wrapper around functionality for classification
and regression, as implemented by mmb.}
\format{
An object of class \code{list} of length 7.
}
\usage{
bayesCaret
}
\description{
A wrapper to be used with the package/function \code{caret::train()}.
Supports regression and classification and an extensive default grid.
}
\examples{
\donttest{
trainIndex <- caret::createDataPartition(
  iris$Species, p = .8, list = FALSE, times = 1)
train <- iris[ trainIndex, ]
test  <- iris[-trainIndex, ]

fitControl <- caret::trainControl(
  method = "repeatedcv", number = 2, repeats = 2)

fit <- caret::train(
  Species ~ ., data = train, method = mmb::bayesCaret,
  trControl = fitControl)
}
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
\keyword{datasets}
