% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mlsjunkgenv.R
\name{mlsjunkgenv}
\alias{mlsjunkgenv}
\title{Generate a vector of pseudo-random numbers using the MLS Junk Generator algorithm}
\usage{
mlsjunkgenv(n = 1, w, x, y, z, round = 5)
}
\arguments{
\item{n}{the number of pseudo-random numbers to generate; defaults to 1}

\item{w}{the first seed required by the MLS Junk Generator algorithm}

\item{x}{the first seed required by the MLS Junk Generator algorithm}

\item{y}{the first seed required by the MLS Junk Generator algorithm}

\item{z}{the first seed required by the MLS Junk Generator algorithm}

\item{round}{the number of decimal places to which to round the pseudo-random numbers; default = 5}
}
\value{
A numeric vector containing a single pseudo-random number
}
\description{
Based on user input seeds, this function generates a vector of n
pseudo-random numbers by calling junkgen.
}
\examples{
# Generate a pseudo-random number stream of length 5 with user-specified seeds

w <- 1
x <- 2
y <- 3
z <- 4

# the following call returns "[1] 0.95516 0.66908 0.21235 0.34488 0.11995"
mlsjunkgenv(n = 5, w = w, x = x, y = y, z = z)

# Specifying different values for n and round

mlsjunkgenv(n = 3, w = w, x = x, y = y, z = z, round = 2) # returns "[1] 0.96 0.67 0.21"

# using the default value of n (1) is identical to running junkgen and rounding
# the result to 5 decimal places

round(junkgen(w = w, x = x, y = y, z = z),5) # returns "[1] 0.95516"
mlsjunkgenv(w = w, x = x, y = y, z = z) # returns "[1] 0.95516"
}

