% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterBoruta.R
\name{mlr_filters_boruta}
\alias{mlr_filters_boruta}
\alias{FilterBoruta}
\title{Burota Filter}
\description{
Filter using the Boruta algorithm for feature selection.
If \code{keep = "tentative"}, confirmed and tentative features are returned.
Note that there is no ordering in the selected features.
Selected features get a score of 1, deselected features get a score of 0.
The order of selected features is random.
In combination with \CRANpkg{mlr3pipelines}, only the filter criterion \code{cutoff} makes sense.
}
\section{Initial parameter values}{

\itemize{
\item \code{num.threads}:
\itemize{
\item Actual default: \code{NULL}, triggering auto-detection of the number of CPUs.
\item Adjusted value: 1.
\item Reason for change: Conflicting with parallelization via \CRANpkg{future}.
}
}
}

\examples{
\donttest{
  if (requireNamespace("Boruta")) {
   task = mlr3::tsk("sonar")
   filter = flt("boruta")
   filter$calculate(task)
   as.data.table(filter)
  }
}
}
\references{
Kursa MB, Rudnicki WR (2010).
\dQuote{Feature Selection with the Boruta Package.}
\emph{Journal of Statistical Software}, \bold{36}(11), 1-13.
}
\seealso{
\itemize{
\item \link[mlr3pipelines:mlr_pipeops_filter]{PipeOpFilter} for filter-based feature selection.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}
}

Other Filter: 
\code{\link{Filter}},
\code{\link{mlr_filters}},
\code{\link{mlr_filters_anova}},
\code{\link{mlr_filters_auc}},
\code{\link{mlr_filters_carscore}},
\code{\link{mlr_filters_carsurvscore}},
\code{\link{mlr_filters_cmim}},
\code{\link{mlr_filters_correlation}},
\code{\link{mlr_filters_disr}},
\code{\link{mlr_filters_find_correlation}},
\code{\link{mlr_filters_importance}},
\code{\link{mlr_filters_information_gain}},
\code{\link{mlr_filters_jmi}},
\code{\link{mlr_filters_jmim}},
\code{\link{mlr_filters_kruskal_test}},
\code{\link{mlr_filters_mim}},
\code{\link{mlr_filters_mrmr}},
\code{\link{mlr_filters_njmim}},
\code{\link{mlr_filters_performance}},
\code{\link{mlr_filters_permutation}},
\code{\link{mlr_filters_relief}},
\code{\link{mlr_filters_selected_features}},
\code{\link{mlr_filters_univariate_cox}},
\code{\link{mlr_filters_variance}}
}
\concept{Filter}
\section{Super class}{
\code{\link[mlr3filters:Filter]{mlr3filters::Filter}} -> \code{FilterBoruta}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FilterBoruta-new}{\code{FilterBoruta$new()}}
\item \href{#method-FilterBoruta-clone}{\code{FilterBoruta$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="calculate"><a href='../../mlr3filters/html/Filter.html#method-Filter-calculate'><code>mlr3filters::Filter$calculate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="format"><a href='../../mlr3filters/html/Filter.html#method-Filter-format'><code>mlr3filters::Filter$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="help"><a href='../../mlr3filters/html/Filter.html#method-Filter-help'><code>mlr3filters::Filter$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="print"><a href='../../mlr3filters/html/Filter.html#method-Filter-print'><code>mlr3filters::Filter$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterBoruta-new"></a>}}
\if{latex}{\out{\hypertarget{method-FilterBoruta-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterBoruta$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterBoruta-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FilterBoruta-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterBoruta$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
