% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian_linear_regression.R
\name{bayesian_linear_regression}
\alias{bayesian_linear_regression}
\title{BayesianLinearRegression}
\usage{
bayesian_linear_regression(
  center = FALSE,
  input = NA,
  input_model = NA,
  responses = NA,
  scale = FALSE,
  test = NA,
  verbose = getOption("mlpack.verbose", FALSE)
)
}
\arguments{
\item{center}{Center the data and fit the intercept if enabled.  Default
value "FALSE" (logical).}

\item{input}{Matrix of covariates (X) (numeric matrix).}

\item{input_model}{Trained BayesianLinearRegression model to use
(BayesianLinearRegression).}

\item{responses}{Matrix of responses/observations (y) (numeric row).}

\item{scale}{Scale each feature by their standard deviations if enabled.
Default value "FALSE" (logical).}

\item{test}{Matrix containing points to regress on (test points)
(numeric matrix).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value
"getOption("mlpack.verbose", FALSE)" (logical).}
}
\value{
A list with several components:
\item{output_model}{Output BayesianLinearRegression model
  (BayesianLinearRegression).}
\item{predictions}{If --test_file is specified, this file is where the
  predicted responses will be saved (numeric matrix).}
\item{stds}{If specified, this is where the standard deviations of the
  predictive distribution will be saved (numeric matrix).}
}
\description{
An implementation of the bayesian linear regression.
}
\details{
An implementation of the bayesian linear regression.
This model is a probabilistic view and implementation of the linear
regression. The final solution is obtained by computing a posterior
distribution from gaussian likelihood and a zero mean gaussian isotropic 
prior distribution on the solution. 
Optimization is AUTOMATIC and does not require cross validation. The
optimization is performed by maximization of the evidence function.
Parameters are tuned during the maximization of the marginal likelihood. This
procedure includes the Ockham's razor that penalizes over complex solutions. 

This program is able to train a Bayesian linear regression model or load a
model from file, output regression predictions for a test set, and save the
trained model to a file.

To train a BayesianLinearRegression model, the "input" and
"responses"parameters must be given. The "center"and "scale" parameters
control the centering and the normalizing options. A trained model can be
saved with the "output_model". If no training is desired at all, a model can
be passed via the "input_model" parameter.

The program can also provide predictions for test data using either the
trained model or the given input model.  Test points can be specified with
the "test" parameter.  Predicted responses to the test points can be saved
with the "predictions" output parameter. The corresponding standard deviation
can be save by precising the "stds" parameter.
}
\examples{
# For example, the following command trains a model on the data "data" and
# responses "responses"with center set to true and scale set to false (so,
# Bayesian linear regression is being solved, and then the model is saved to
# "blr_model":

\dontrun{
output <- bayesian_linear_regression(input=data, responses=responses,
  center=1, scale=0)
blr_model <- output$output_model
}

# The following command uses the "blr_model" to provide predicted  responses
# for the data "test" and save those  responses to "test_predictions": 

\dontrun{
output <- bayesian_linear_regression(input_model=blr_model, test=test)
test_predictions <- output$predictions
}

# Because the estimator computes a predictive distribution instead of a
# simple point estimate, the "stds" parameter allows one to save the
# prediction uncertainties: 

\dontrun{
output <- bayesian_linear_regression(input_model=blr_model, test=test)
test_predictions <- output$predictions
stds <- output$stds
}
}
\author{
mlpack developers
}
