% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{mlmm.gwas.FMI}
\alias{mlmm.gwas.FMI}
\alias{floweringDateFMI}
\alias{female}
\alias{male}
\alias{hybrid}
\alias{Xf}
\alias{Xm}
\alias{Xfm}
\alias{K.female}
\alias{K.male}
\alias{K.hybrid}
\title{Dataset for examples with the mlmm.gwas package, male+female and male+female+interaction models}
\format{\itemize{
  \item floweringDateFMI: a named numeric vector of length 303.
  \item female: a factor of length 303
  \item male: a factor of length 303
  \item hybrid: a factor of length 303
  \item Xf: a 303x500 numeric matrix
  \item Xm: a 303x500 numeric matrix
  \item Xfm: a 303x500 numeric matrix
  \item K.female: 36x36 numeric matrix
  \item K.male: 36x36 numeric matrix
  \item K.hybrid: 303x303 numeric matrix
}}
\source{
\href{https://link.springer.com/article/10.1007/s00122-017-3003-4}{Bonnafous & al. (2017)}
}
\usage{
data(mlmm.gwas.FMI)
}
\description{
\itemize{
   \item Species: Helianthus annuus
   \item Individuals: 303
   \item Markers: 500
}
}
\details{
Variables:
\itemize{
  \item floweringDateFMI: flowering dates in °C.day, time since sowing.
  \item female: names of the female parent of the individuals
  \item male: names of the male parent of the individuals
  \item hybrid: names of the hybrids (name of female and male)
  \item Xf: female genotype matrix (additive)
  \item Xm: male genotype matrix (dominance)
  \item Xfm: female-male interaction genotype matrix (dominance)
  \item K.female: female "kinship" matrix (additive)
  \item K.male: male "kinship" matrix (dominance)
  \item K.hybrid: hybrid "kinship" matrix (dominance)
}
}
\keyword{dataset}
