% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steady.R
\name{distanceMaxRelRDI}
\alias{distanceMaxRelRDI}
\title{Measure distance between current and previous state in terms of RDI}
\usage{
distanceMaxRelRDI(params, current, previous)
}
\arguments{
\item{params}{MizerParams}

\item{current}{A named list with entries \code{n}, \code{n_pp} and \code{n_other}
describing the current state}

\item{previous}{A named list with entries \code{n}, \code{n_pp} and \code{n_other}
describing the previous state}
}
\value{
The largest absolute relative change in rdi:
\code{max(abs((current_rdi - previous_rdi) / previous_rdi))}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function can be used in \code{\link[=projectToSteady]{projectToSteady()}} to decide when sufficient
convergence to steady state has been achieved.
}
\seealso{
Other distance functions: 
\code{\link{distanceSSLogN}()}
}
\concept{distance functions}
\concept{helper}
