% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mize.R
\name{make_mize}
\alias{make_mize}
\title{Create an Optimizer}
\usage{
make_mize(
  method = "L-BFGS",
  norm_direction = FALSE,
  scale_hess = TRUE,
  memory = 5,
  cg_update = "PR+",
  preconditioner = "",
  tn_init = 0,
  tn_exit = "curvature",
  nest_q = 0,
  nest_convex_approx = FALSE,
  nest_burn_in = 0,
  step_up = 1.1,
  step_up_fun = c("*", "+"),
  step_down = NULL,
  dbd_weight = 0.1,
  line_search = "More-Thuente",
  c1 = 1e-04,
  c2 = NULL,
  step0 = NULL,
  step_next_init = NULL,
  try_newton_step = NULL,
  ls_max_fn = 20,
  ls_max_gr = Inf,
  ls_max_fg = Inf,
  ls_max_alpha_mult = Inf,
  ls_max_alpha = Inf,
  ls_safe_cubic = FALSE,
  strong_curvature = NULL,
  approx_armijo = NULL,
  mom_type = NULL,
  mom_schedule = NULL,
  mom_init = NULL,
  mom_final = NULL,
  mom_switch_iter = NULL,
  mom_linear_weight = FALSE,
  use_init_mom = FALSE,
  restart = NULL,
  restart_wait = 10,
  par = NULL,
  fg = NULL,
  max_iter = 100,
  max_fn = Inf,
  max_gr = Inf,
  max_fg = Inf,
  abs_tol = NULL,
  rel_tol = abs_tol,
  grad_tol = NULL,
  ginf_tol = NULL,
  step_tol = NULL
)
}
\arguments{
\item{method}{Optimization method. See 'Details' of \code{\link{mize}}.}

\item{norm_direction}{If \code{TRUE}, then the steepest descent direction is
normalized to unit length. Useful for adaptive step size methods where the
previous step size is used to initialize the next iteration.}

\item{scale_hess}{if \code{TRUE}, the approximation to the inverse Hessian is
scaled according to the method described by Nocedal and Wright
(approximating an eigenvalue). Applies only to the methods \code{BFGS}
(where the scaling is applied only during the first step) and \code{L-BFGS}
(where the scaling is applied during every iteration). Ignored otherwise.}

\item{memory}{The number of updates to store if using the \code{L-BFGS}
method. Ignored otherwise. Must be a positive integer.}

\item{cg_update}{Type of update to use for the \code{"CG"} method. For
details see the "CG" subsection of the "Optimization Methods" section.
Ignored if \code{method} is not \code{"CG"}.}

\item{preconditioner}{Type of preconditioner to use in Truncated Newton.
Leave blank or set to  \code{"L-BFGS"} to use a limited memory BFGS
preconditioner. Use the \code{"memory"} parameter to control the number of
updates to store. Applies only if \code{method = "TN"}, or \code{"CG"},
ignored otherwise.}

\item{tn_init}{Type of initialization to use in inner loop of Truncated
Newton. Use \code{0} to use the zero vector (the usual TN initialization),
or \code{"previous"} to use the final result from the previous iteration,
as suggested by Martens (2010). Applies only if \code{method = "TN"},
ignored otherwise.}

\item{tn_exit}{Type of exit criterion to use when terminating the inner CG
loop of Truncated Newton method. Either \code{"curvature"} to use the
standard negative curvature test, or \code{"strong"} to use the modified
"strong" curvature test in TNPACK (Xie and Schlick, 1999). Applies only
if \code{method = "TN"}, ignored otherwise.}

\item{nest_q}{Strong convexity parameter for the \code{"NAG"} method's
momentum term. Must take a value between 0 (strongly convex) and 1 (results
in steepest descent).Ignored unless the \code{method} is \code{"NAG"} and
\code{nest_convex_approx} is \code{FALSE}.}

\item{nest_convex_approx}{If \code{TRUE}, then use an approximation due to
Sutskever for calculating the momentum parameter in the NAG method. Only
applies if \code{method} is \code{"NAG"}.}

\item{nest_burn_in}{Number of iterations to wait before using a non-zero
momentum. Only applies if using the \code{"NAG"} method or setting the
\code{momentum_type} to "Nesterov".}

\item{step_up}{Value by which to increase the step size for the \code{"bold"}
step size method or the \code{"DBD"} method.}

\item{step_up_fun}{Operator to use when combining the current step size with
\code{step_up}. Can be one of \code{"*"} (to multiply the current step size
with \code{step_up}) or \code{"+"} (to add).}

\item{step_down}{Multiplier to reduce the step size by if using the
\code{"DBD"} method or the \code{"bold"}. Can also be used with the
\code{"back"} line search method, but is optional. Should be a positive
value less than 1.}

\item{dbd_weight}{Weighting parameter used by the \code{"DBD"} method only,
and only if no momentum scheme is provided. Must be an integer between 0
and 1.}

\item{line_search}{Type of line search to use. See 'Details' of
\code{\link{mize}}.}

\item{c1}{Sufficient decrease parameter for Wolfe-type line searches. Should
be a value between 0 and 1.}

\item{c2}{Sufficient curvature parameter for line search for Wolfe-type line
searches. Should be a value between \code{c1} and 1.}

\item{step0}{Initial value for the line search on the first step. See
'Details' of \code{\link{mize}}.}

\item{step_next_init}{For Wolfe-type line searches only, how to initialize
the line search on iterations after the first. See 'Details' of
\code{\link{mize}}.}

\item{try_newton_step}{For Wolfe-type line searches only, try the line step
value of 1 as the initial step size whenever \code{step_next_init} suggests
a step size > 1. Defaults to \code{TRUE} for quasi-Newton methods such as
BFGS and L-BFGS, \code{FALSE} otherwise.}

\item{ls_max_fn}{Maximum number of function evaluations allowed during a line
search.}

\item{ls_max_gr}{Maximum number of gradient evaluations allowed during a line
search.}

\item{ls_max_fg}{Maximum number of function or gradient evaluations allowed
during a line search.}

\item{ls_max_alpha_mult}{The maximum value that can be attained by the ratio
of the initial guess for alpha for the current line search, to the final
value of alpha of the previous line search. Used to stop line searches
diverging due to very large initial guesses. Only applies for Wolfe-type
line searches.}

\item{ls_max_alpha}{Maximum value of alpha allowed during line search. Only
applies for \code{line_search = "more-thuente"}.}

\item{ls_safe_cubic}{(Optional). If \code{TRUE}, check that cubic
interpolation in the Wolfe line search does not produce too small a value.
Only applies for \code{line_search = "more-thuente"}.}

\item{strong_curvature}{(Optional). If \code{TRUE} use the strong
curvature condition in Wolfe line search. See the 'Line Search' section of
\code{\link{mize}} for details.}

\item{approx_armijo}{(Optional). If \code{TRUE} use the approximate Armijo
condition in Wolfe line search. See the 'Line Search' section of
\code{\link{mize}} for details.}

\item{mom_type}{Momentum type, either \code{"classical"} or
\code{"nesterov"}.}

\item{mom_schedule}{Momentum schedule. See 'Details' of \code{\link{mize}}.}

\item{mom_init}{Initial momentum value.}

\item{mom_final}{Final momentum value.}

\item{mom_switch_iter}{For \code{mom_schedule} \code{"switch"} only, the
iteration when \code{mom_init} is changed to \code{mom_final}.}

\item{mom_linear_weight}{If \code{TRUE}, the gradient contribution to the
update is weighted using momentum contribution.}

\item{use_init_mom}{If \code{TRUE}, then the momentum coefficient on the
first iteration is non-zero. Otherwise, it's zero. Only applies if using a
momentum schedule.}

\item{restart}{Momentum restart type. Can be one of "fn" or "gr". See
'Details' of \code{\link{mize}}.}

\item{restart_wait}{Number of iterations to wait between restarts. Ignored if
\code{restart} is \code{NULL}.}

\item{par}{(Optional) Initial values for the function to be optimized over.}

\item{fg}{(Optional). Function and gradient list. See 'Details' of
\code{\link{mize}}.}

\item{max_iter}{(Optional). Maximum number of iterations. See the
'Convergence' section of \code{\link{mize}} for details.}

\item{max_fn}{(Optional). Maximum number of function evaluations. See the
'Convergence' section of \code{\link{mize}} for details.}

\item{max_gr}{(Optional). Maximum number of gradient evaluations. See the
'Convergence' section of \code{\link{mize}} for details.}

\item{max_fg}{(Optional). Maximum number of function or gradient evaluations.
See the 'Convergence' section of \code{\link{mize}} for details.}

\item{abs_tol}{(Optional). Absolute tolerance for comparing two function
evaluations. See the 'Convergence' section of \code{\link{mize}} for
details.}

\item{rel_tol}{(Optional). Relative tolerance for comparing two function
evaluations. See the 'Convergence' section of \code{\link{mize}} for
details.}

\item{grad_tol}{(Optional). Absolute tolerance for the length (l2-norm) of
the gradient vector. See the 'Convergence' section of \code{\link{mize}}
for details.}

\item{ginf_tol}{(Optional). Absolute tolerance for the infinity norm (maximum
absolute component) of the gradient vector. See the 'Convergence' section
of \code{\link{mize}} for details.}

\item{step_tol}{(Optional). Absolute tolerance for the size of the parameter
update. See the 'Convergence' section of \code{\link{mize}} for details.}
}
\description{
Factory function for creating a (possibly uninitialized) optimizer.
}
\details{
If the function to be optimized and starting point are not present at
creation time, then the optimizer should be initialized using
\code{\link{mize_init}} before being used with \code{\link{mize_step}}.

See the documentation to \code{\link{mize}} for an explanation of all the
parameters.

Details of the \code{fg} list containing the function to be optimized and its
gradient can be found in the 'Details' section of \code{\link{mize}}. It is
optional for this function, but if it is passed to this function, along with
the vector of initial values, \code{par}, the optimizer will be returned
already initialized for this function. Otherwise, \code{\link{mize_init}}
must be called before optimization begins.

Additionally, optional convergence parameters may also be passed here, for
use with \code{\link{check_mize_convergence}}. They are optional here if you
plan to call \code{\link{mize_init}} later, or if you want to do your own
convergence checking.
}
\examples{
# Function to optimize and starting point
rosenbrock_fg <- list(
  fn = function(x) {
    100 * (x[2] - x[1] * x[1])^2 + (1 - x[1])^2
  },
  gr = function(x) {
    c(
      -400 * x[1] * (x[2] - x[1] * x[1]) - 2 * (1 - x[1]),
      200 * (x[2] - x[1] * x[1])
    )
  }
)
rb0 <- c(-1.2, 1)

# Create an optimizer and initialize it for use with the Rosenbrock function
opt <- make_mize(method = "L-BFGS", par = rb0, fg = rosenbrock_fg)

# Create optimizer without initialization
opt <- make_mize(method = "L-BFGS")

# Need to call mize_init separately:
opt <- mize_init(opt, rb0, rosenbrock_fg)
}
