% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_tree_contexts.R, R/ctx_tree_cpp_contexts.R
\name{contexts.ctx_tree}
\alias{contexts.ctx_tree}
\alias{contexts.ctx_tree_cpp}
\title{Contexts of a context tree}
\usage{
\method{contexts}{ctx_tree}(
  ct,
  sequence = FALSE,
  reverse = FALSE,
  frequency = NULL,
  positions = FALSE,
  ...
)

\method{contexts}{ctx_tree_cpp}(
  ct,
  sequence = FALSE,
  reverse = FALSE,
  frequency = NULL,
  positions = FALSE,
  ...
)
}
\arguments{
\item{ct}{a context tree.}

\item{sequence}{if \code{TRUE} the function returns its results as a \code{data.frame},
if \code{FALSE} (default) as a list of \code{ctx_node} objects. (see details)}

\item{reverse}{logical (defaults to \code{FALSE}). See details.}

\item{frequency}{specifies the counts to be included in the result
data.frame. The default value of \code{NULL} does not include anything.
\code{"total"} gives the number of occurrences of each context in the original
sequence. \code{"detailed"} includes in addition the break down of these
occurrences into all the possible states.}

\item{positions}{logical (defaults to FALSE). Specify whether the positions
of each context in the time series used to build the context tree should be
reported in a \code{positions} column of the result data frame. The availability
of the positions depends on the way the context tree was built. See details
for the definition of a position.}

\item{...}{additional arguments for the contexts function.}
}
\value{
A list of class \code{contexts} containing the contexts represented in
this tree (as \code{ctx_node}) or a data.frame.
}
\description{
This function extracts from a context tree a description of all of its
contexts.
}
\details{
The default behaviour of the function is to return a list of all the
contexts using \code{ctx_node} objects (as returned by \code{\link[=find_sequence]{find_sequence()}}). The
properties of the contexts can then be explored using adapted functions
such as \code{\link[=counts]{counts()}} and \code{\link[=positions]{positions()}}.

When \code{sequence=TRUE} the method returns a data.frame whose first column,
named \code{context}, contains the contexts as vectors (i.e. the value returned
by \code{as_sequence()} applied to a \code{ctx_node} object). Other columns contain
context specific values specified by the additional parameters. Setting any
of those parameters to a value that ask for reporting information will
toggle the result type of the function to \code{data.frame}.

If \code{frequency="total"}, an additional column named \code{freq} gives the number
of occurrences of each context in the series used to build the tree. If
\code{frequency="detailed"}, one additional column is added per state in the
context space. Each column records the number of times a given context is
followed by the corresponding value in the original series.
}
\section{Positions}{
 A position of a context \code{ctx} in the time series \code{x} is
an index value \code{t} such that the context ends with \code{x[t]}. Thus \code{x[t+1]} is
after the context. For instance if \code{x=c(0, 0, 1, 1)} and \code{ctx=c(0, 1)} (in
standard state order), then the position of \code{ctx} in \code{x} is 3.
}

\section{State order in a context}{
 Notice that contexts are given by default
in the temporal order and not in the "reverse" order used by many VLMC
research papers: older values are on the left. For instance, the context
\code{c(1, 0)} is reported if the sequence 0, then 1 appeared in the time series
used to build the context tree. Set reverse to \code{TRUE} for the reverse
convention which is somewhat easier to relate to the way the context trees
are represented by \code{\link[=draw]{draw()}} (i.e. recent values at the top the tree).
}

\examples{
dts <- sample(as.factor(c("A", "B", "C")), 100, replace = TRUE)
dts_tree <- ctx_tree(dts, max_depth = 3, min_size = 5)
## direct representation with ctx_node objects
contexts(dts_tree)
## data.frame format
contexts(dts_tree, sequence = TRUE)
contexts(dts_tree, frequency = "total")
contexts(dts_tree, frequency = "detailed")
}
\seealso{
\code{\link[=find_sequence]{find_sequence()}} and \code{\link[=find_sequence.covlmc]{find_sequence.covlmc()}} for direct access to
a specific context, and \code{\link[=contexts.ctx_tree]{contexts.ctx_tree()}}, \code{\link[=contexts.vlmc]{contexts.vlmc()}} and
\code{\link[=contexts.covlmc]{contexts.covlmc()}} for concrete implementations of \code{contexts()}.
}
