% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rmixedMem.R
\name{rmixedMem}
\alias{rmixedMem}
\title{Simulate Mixed Membership Data}
\usage{
rmixedMem(Total, J, Rj, Nijr, K, Vj, dist, theta, alpha, lambda = NULL)
}
\arguments{
\item{Total}{the number of individuals in the sample.}

\item{J}{the number of variables observed on each individual.}

\item{Rj}{a vector of positive integers of length \code{J} specifying the number of repeated measurements
for each variable.}

\item{Nijr}{an array of dimension (\code{Total}, \code{J}, \code{max(Rj)}) indicating the number
of ranking levels for each replication. For multinomial and Bernoulli
variables, \code{Nijr}[i,j,r] = 1. For rank variables, \code{Nijr}[i,j,r] indicates the
number of items ranked for each individual.}

\item{K}{the number of latent sub-populations.}

\item{Vj}{a vector of length \code{J} specifying the number of possible candidates
for each variable. For a Bernoulli variable \code{Vj}[j] = 1. For a multinomial
 or rank variable, \code{Vj}[j] is the number of possible categories/items.}

\item{dist}{a vector of strings of length \code{J} specifying variable types. Options are
"bernoulli", "multinomial" or "rank" corresponing to the distributions
 of the observed variables.}

\item{theta}{an 3 way array of dimensions (\code{J},\code{K},\code{max(Vj)}) which governs the variable
distributions. Parameter \code{theta}[j,k,] governs the distirbution of responses on variable j for an inidvidually completely in sub-population k.
If the number of items/categories differs across variables, any
unusued portions of \code{theta} should be set to 0.}

\item{alpha}{a positive \code{K}-length vector  which is the parameter for the Dirichlet
distribution of membership scores.}

\item{lambda}{an optional matrix of dimensions (\code{Total}, \code{K}) containing the membership scores for each individual. If the \code{lambda}
argument is not specified, the group membership scores will be automatically sampled from a Dirichlet(\code{alpha})}
}
\value{
\code{rmixedMem} returns a list containing a three items: A matrix of group memberships scores \code{lambda},
an array of context indicators \code{Z} and an array of observations \code{obs}.
}
\description{
Simulate data from a mixed membership model.
}
\details{
\code{rmixedMem} simulates data from a mixed membership model given the specified parameters and dimensions. The function
returns a random sample of observations \code{obs}, context indicators \code{Z}, and group membership scores \code{lambda}.
}

