% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bic_lsr.R
\name{bic_lsr}
\alias{bic_lsr}
\title{Compute Bayesian information criterion for a mixedLSR model}
\usage{
bic_lsr(a, n, llik)
}
\arguments{
\item{a}{A list of coefficient matrices.}

\item{n}{The sample size.}

\item{llik}{The log-likelihood of the model.}
}
\value{
The BIC.
}
\description{
Compute Bayesian information criterion for a mixedLSR model
}
\examples{
n <- 50
simulate <- simulate_lsr(n)
model <- mixed_lsr(simulate$x, simulate$y, k = 2, init_lambda = c(1,1), alt_iter = 0)
bic_lsr(model$A, n = n, model$llik)
}
