test_that("Check initialization methods", {
  skip_on_cran()
  skip_on_bioc()
  
  # Arrange
  # set.seed(10)
  # x = rmixnormal(100, c(0.4, 0.6), c(-3, 2), c(2, 1))
  x = c(-3.36850508413813, -5.74266109984502, -4.19833543156744, -2.41090974686498, 
        -2.22041139859967, -5.41615235085897, -3.72735203494172, -6.25334536340618, 
        -3.51295678824798, -0.796440993825738, -1.48843698394533, -3.47646711203744, 
        -1.02511059317322, -1.51721974323235, -2.82130546700836, -4.90988771230476, 
        -3.39030076933448, -1.14895747581184, -2.03404295032678, -4.19262127344041, 
        -7.37057367633906, -4.34973187575023, -7.23812238382035, -5.53039604306181, 
        -3.7473231103094, -4.37511086077584, -4.74431765343538, -3.20352201244963, 
        -3.50756106020492, -6.70748090895828, -3.15589213215073, -1.06286731895092, 
        -2.63014808001937, -5.75988715667517, -5.87102872472074, -2.27582554278679, 
        0.240913246240293, 1.67545599042767, 1.34843701145534, 3.08655139944051, 
        1.23745511996871, 1.17133746499891, 2.83447390308845, 1.03234801324009, 
        1.97118466452414, 2.23252515257539, 1.69879131849582, 1.32238541685067, 
        2.65522763623522, 1.59936245296826, 1.66544343492665, 3.36795395319196, 
        4.13776710365012, 2.50581926452903, 2.78634238423916, 1.09778805582136, 
        2.53289699232833, 1.35410574645079, 2.29098748842977, 0.76240553112278, 
        1.54382372488219, 1.16967734527527, 2.34011564367426, 3.06637639568217, 
        3.2161258380798, 2.73569065763305, 1.51879138268442, 2.56274476285812, 
        0.7536802881108, 2.38092221262568, 0.569572747203306, 0.951554495121401, 
        1.78149644946541, 0.510063763264465, 3.17270628121431, 0.52017297842834, 
        1.56961218392278, 0.948361357956554, 3.5225863440541, 2.59282805458608, 
        1.77733849098073, 2.71289427624846, 2.71660083374105, 2.44024186438414, 
        2.1588306213181, 2.65976413833195, 4.22051966293556, 0.816054925934599, 
        1.92604416550251, 1.58364532511348, 1.80851765624737, 2.0695447814074, 
        3.15534831801052, 2.59495734695049, 0.580354891643012, 0.39332275464196, 
        2.89292589956318, 2.14816795518773, 3.22702839010139, 1.23819566082197)
  
  # Act
  expected_output1 =  list(pi = c(0.35, 0.65), 
                           mu = c(-3.83956479769982, 1.94398028641787), 
                           sd = c(1.76518240566615, 0.999224865939071))
  expected_output2 = list(pi = c(0.36, 0.64), 
                          mu = c(-3.75503358092554, 1.98679936892168), 
                          sd = c(1.81220392251347, 0.945109132653641))
  actual_output1 = initz(x, ncomp = 2)
  actual_output2 = initz(x, ncomp = 2, init.method = 'hclust')
  
  # Assert
  expect_equal(actual_output1, expected_output1, tolerance = 1e-2)
  expect_equal(actual_output2, expected_output2, tolerance = 1e-2)
})
