% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missoNet-package.R
\docType{package}
\encoding{UTF-8}
\name{missoNet-package}
\alias{missoNet-package}
\alias{package}
\title{missoNet: Multi-Task Regression and Conditional Network Estimation with Missing Responses}
\description{
\pkg{missoNet} fits a joint multivariate regression and conditional
dependency (precision–matrix) model when some response entries are missing.
The method estimates a sparse coefficient matrix \eqn{B} linking
predictors \eqn{X} to multivariate responses \eqn{Y}, together with a sparse
inverse covariance \eqn{\Theta} for the residuals in
\eqn{Y = \mathbf{1}\mu^{\mathsf{T}} + XB + E}, \eqn{E \sim \mathcal{N}(0, \Theta^{-1})}.
Responses may contain missing values (e.g., MCAR/MAR); predictors must be
finite. The package provides cross-validation, prediction, publication-ready
plotting, and simple simulation utilities.
}
\details{
\strong{Key features}
\itemize{
\item Joint estimation of \eqn{B} (regression) and \eqn{\Theta} (conditional network).
\item \eqn{\ell_1}-regularization on both \eqn{B} and \eqn{\Theta} with user-controlled grids.
\item K-fold cross-validation with optional 1-SE model selections.
\item Heatmap and 3D surface visualizations for CV error or GoF across
\eqn{(\lambda_B,\lambda_\Theta)}.
\item Fast prediction for new data using stored solutions.
\item Lightweight data generator for simulation studies.
}

\strong{Workflow}
\enumerate{
\item Fit a model across a grid of penalties with \code{\link{missoNet}} or
select penalties via \code{\link{cv.missoNet}}.
\item Visualize the CV error/GoF surface with \code{\link{plot.missoNet}}.
\item Predict responses for new observations with \code{\link{predict.missoNet}}.
}
}
\section{Main functions}{

\describe{
\item{\code{\link{missoNet}}}{Fit models over user-specified penalty grids for
\eqn{\lambda_B} and \eqn{\lambda_\Theta}; returns estimated
\eqn{\mu}, \eqn{B}, \eqn{\Theta}, and metadata (grids, GoF).}
\item{\code{\link{cv.missoNet}}}{Perform k-fold cross-validation over a penalty grid;
stores \code{est.min} and (optionally) \code{est.1se.beta},
\code{est.1se.theta}.}
\item{\code{\link{plot.missoNet}}}{S3 plotting method; heatmap or 3D scatter of CV error or GoF.}
\item{\code{\link{predict.missoNet}}}{S3 prediction method; returns
\eqn{\hat{Y} = \mathbf{1}\hat{\mu}^{\mathsf{T}} + X_\mathrm{new}\hat{B}} for a chosen solution.}
\item{\code{\link{generateData}}}{Generate synthetic datasets with controllable
dimensions, signal, and missingness mechanisms for benchmarking.}
}
}

\section{License}{

GPL-2.
}

\examples{
sim <- generateData(n = 100, p = 8, q = 5, rho = 0.1, missing.type = "MCAR")

\donttest{
fit <- missoNet(X = sim$X, Y = sim$Z)             # fit over a grid
plot(fit)                                         # GoF heatmap

cvfit <- cv.missoNet(X = sim$X, Y = sim$Z, kfold = 5, compute.1se = TRUE)
plot(cvfit, type = "scatter", plt.surf = TRUE)    # CV error surface
yhat  <- predict(cvfit, newx = sim$X, s = "lambda.min")
}

}
\seealso{
\code{\link{missoNet}}, \code{\link{cv.missoNet}}, \code{\link{plot.missoNet}},
\code{\link{predict.missoNet}}, \code{\link{generateData}},
and \code{browseVignettes("missoNet")} for tutorials.
}
\author{
\strong{Maintainer}: Yixiao Zeng \email{yixiao.zeng@mail.mcgill.ca} [copyright holder]

Authors:
\itemize{
  \item Celia Greenwood \email{celia.greenwood@mcgill.ca} [thesis advisor]
}

}
