% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-tracks.R
\name{gintervals.summary}
\alias{gintervals.summary}
\title{Calculates summary statistics of track expression for intervals}
\usage{
gintervals.summary(
  expr = NULL,
  intervals = NULL,
  iterator = NULL,
  band = NULL,
  intervals.set.out = NULL
)
}
\arguments{
\item{expr}{track expression}

\item{intervals}{set of intervals}

\item{iterator}{track expression iterator. If 'NULL' iterator is determined
implicitly based on track expression.}

\item{band}{track expression band. If 'NULL' no band is used.}

\item{intervals.set.out}{intervals set name where the function result is
optionally outputted}
}
\value{
If 'intervals.set.out' is 'NULL' a set of intervals with additional
columns representing summary statistics for each percentile and interval.
}
\description{
Calculates summary statistics of track expression for intervals.
}
\details{
This function returns summary statistics of a track expression for each
interval 'intervals': total number of bins, total number of bins whose value
is NaN, min, max, sum, mean and standard deviation of the values.

If 'intervals.set.out' is not 'NULL' the result is saved as an intervals
set. Use this parameter if the result size exceeds the limits of the
physical memory.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
intervs <- gintervals(c(1, 2), 0, 5000)
gintervals.summary("dense_track", intervs)

}
\seealso{
\code{\link{gsummary}}, \code{\link{gbins.summary}}
}
\keyword{~statistics}
\keyword{~summary}
