% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-operations.R
\name{gintervals.normalize}
\alias{gintervals.normalize}
\title{Normalize intervals to a fixed size}
\usage{
gintervals.normalize(intervals = NULL, size = NULL, intervals.set.out = NULL)
}
\arguments{
\item{intervals}{intervals set}

\item{size}{target size for normalized intervals (must be positive integer)}

\item{intervals.set.out}{intervals set name where the function result is saved.
If NULL, the result is returned to the user.}
}
\value{
Normalized intervals set with fixed size, or NULL if result is saved to intervals.set.out
}
\description{
This function normalizes intervals by computing their centers and then expanding
them to a fixed size, while ensuring they don't cross chromosome boundaries.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
intervs <- gintervals(1, c(1000, 5000), c(2000, 6000))
gintervals.normalize(intervs, 500)

}
\seealso{
\code{\link{gintervals.force_range}}
}
