% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-index.R
\name{gdb.info}
\alias{gdb.info}
\title{Get Database Information}
\usage{
gdb.info(groot = NULL)
}
\arguments{
\item{groot}{Root directory of the database. If NULL, uses the currently active database.}
}
\value{
A list with database information:
\itemize{
  \item \code{path} - Full path to the database
  \item \code{is_db} - TRUE if this is a valid misha database
  \item \code{format} - "indexed" or "per-chromosome"
  \item \code{num_chromosomes} - Number of chromosomes/contigs
  \item \code{genome_size} - Total length of genome in bases
  \item \code{chromosomes} - Data frame with chromosome names and sizes
}
}
\description{
Returns information about a misha genome database including format, number of chromosomes,
total genome size, and whether it uses the indexed format.
}
\examples{
\dontrun{
# Get info about currently active database
info <- gdb.info()
cat("Database format:", info$format, "\n")
cat("Genome size:", info$genome_size / 1e6, "Mb\n")

# Get info about specific database
info <- gdb.info("/path/to/database")
}

}
