% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleGroup-methods.R
\name{traditional2mirt}
\alias{traditional2mirt}
\title{Convert traditional IRT metric into slope-intercept form used in mirt}
\usage{
traditional2mirt(x, cls, ncat)
}
\arguments{
\item{x}{a vector of parameters to transform}

\item{cls}{the class or itemtype of the supplied model}

\item{ncat}{the number of categories implied by the IRT model}
}
\value{
a named vector of slope-intercept parameters (if supported)
}
\description{
This is a helper function for users who have previously available traditional/classical
IRT parameters and want to know the equivalent slope-intercept translation used in \code{mirt}.
Note that this function assumes that the supplied models are unidimensional by definition (i.e.,
will have only one slope/discrimination) and in the logistic metric (i.e., logistic-ogive
scaling coefficient D=1). If there is no supported slope-intercept transformation
available then the original vector of parameters will be returned by default.
}
\details{
Supported class transformations for the \code{cls} input are:

\describe{
  \item{Rasch, 2PL, 3PL, 3PLu, 4PL}{
    Form must be: (discrimination, difficulty, lower-bound, upper-bound)
    }
  \item{graded}{
    Form must be: (discrimination, difficulty 1, difficulty 2, ..., difficulty k-1)
    }
  \item{gpcm}{
    Form must be: (discrimination, difficulty 1, difficulty 2, ..., difficulty k-1)
    }
  \item{nominal}{
    Form must be: (discrimination 1, discrimination 2, ..., discrimination k,
      difficulty 1, difficulty 2, ..., difficulty k)
    }
}
}
\examples{

# classical 3PL model
vec <- c(a=1.5, b=-1, g=.1, u=1)
slopeint <- traditional2mirt(vec, '3PL', ncat=2)
slopeint

# classical graded model (four category)
vec <- c(a=1.5, b1=-1, b2=0, b3=1.5)
slopeint <- traditional2mirt(vec, 'graded', ncat=4)
slopeint

# classical generalize partial credit model (four category)
vec <- c(a=1.5, b1=-1, b2=0, b3=1.5)
slopeint <- traditional2mirt(vec, 'gpcm', ncat=4)
slopeint

# classical nominal model (4 category)
vec <- c(a1=.5, a2 = -1, a3=1, a4=-.5, d1=1, d2=-1, d3=-.5, d4=.5)
slopeint <- traditional2mirt(vec, 'nominal', ncat=4)
slopeint


}
