% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/next.R
\name{nextstream}
\alias{nextstream}
\alias{nextget}
\alias{nextcode}
\title{Next >> Developer Interface}
\usage{
nextstream(.compute = "default")

nextget(x, .compute = "default")

nextcode(xc)
}
\arguments{
\item{.compute}{character value for the compute profile to use (each has its
own independent set of daemons), or NULL to use the 'default' profile.}

\item{x}{character value of item to retrieve. One of \code{"n"} (number of
dispatcher daemons), \code{"dispatcher"} (the URL dispatcher uses to connect to
host) \code{"url"} (the URL to connect to dispatcher from daemons) or \code{"tls"}
(the stored client TLS configuration for use by daemons).}

\item{xc}{integer return value of \code{\link[=daemon]{daemon()}}.}
}
\value{
For \code{nextstream}: a length 7 integer vector, as given by
\code{.Random.seed} when the L'Ecuyer-CMRG RNG is in use (may be passed directly
to the \code{rs} argument of \code{\link[=daemon]{daemon()}}), or else NULL if a stream has not yet
been created.

For \code{nextget}: the requested item, or else NULL if not present.

For \code{nextcode}: character string.
}
\description{
\code{nextstream} retrieves the currently stored L'Ecuyer-CMRG RNG stream
for the specified compute profile and advances it to the next stream.

\code{nextget} retrieves the specified item from the specified compute profile.

\code{nextcode} translates integer exit codes returned by \code{\link[=daemon]{daemon()}}.
}
\details{
These functions are exported for use by packages extending \pkg{mirai} with
alternative launchers of \code{\link[=daemon]{daemon()}} processes.

For \code{nextstream}: This function should be called for its return value
when required. The function also has the side effect of automatically
advancing the stream stored within the compute profile. This ensures that the
next recursive stream is returned when the function is called again.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
daemons(1L)
nextstream()
nextstream()

nextget("url")

daemons(0)
\dontshow{\}) # examplesIf}
nextcode(0L)
nextcode(1L)

}
\keyword{internal}
