% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tnorm_lscv}
\alias{tnorm_lscv}
\title{Least squares cross-validation for truncated Gaussian kernel density estimation}
\usage{
tnorm_lscv(x, Omega, beta, xsamp, dxsamp, mckern = TRUE)
}
\arguments{
\item{x}{\code{n} by \code{d} matrix of observations}

\item{Omega}{smoothing positive-definite matrix}

\item{beta}{vector of constraints for the half-space}

\item{xsamp}{\code{n} by \code{d} random sample for Monte Carlo estimation of bias}

\item{dxsamp}{\code{n} vector of density for the points from \code{xsamp}}

\item{mckern}{logical; if \code{TRUE}, uses the kernel as sampler for Monte Carlo estimation}
}
\value{
least square criterion value
}
\description{
Least squares cross-validation for truncated Gaussian samples.
}
\keyword{internal}
