% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cylinder-bundle-geometry.R
\name{plot.bundle}
\alias{plot.bundle}
\title{Plots a cross section of a cylinder bundle}
\usage{
\method{plot}{bundle}(x, grid_size = 100L, ...)
}
\arguments{
\item{x}{An object of class \code{bundle} as generated by
\code{\link[=simulate_bundle]{simulate_bundle()}}.}

\item{grid_size}{An integer value specifying the number of points on which
the unit circle should be discretized to draw the spheres. Defaults to
\code{100L}.}

\item{...}{Additional arguments to be passed to the \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}}
method.}
}
\value{
Nothing.
}
\description{
Plots a cross section of a cylinder bundle
}
\examples{
density <- 0.5
voxel_size <- 5 # micrometers
withr::with_seed(1234, {
  out <- simulate_bundle(density, voxel_size)
})
plot(out)
}
