% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cylinder-radial-compartment.R
\name{CylinderRadialCompartment}
\alias{CylinderRadialCompartment}
\title{Cylinder radial compartment class}
\description{
A class to model restricted diffusion in a cylinder in the plane
perpendicular to the cylinder axis.
}
\examples{

## ------------------------------------------------
## Method `CylinderRadialCompartment$get_signal`
## ------------------------------------------------

sodermanComp <- SodermanCompartment$new(
  radius = 1e-6,
  diffusivity = 2.0e-9
)
sodermanComp$get_signal(0.03, 0.03, 0.040)

staniszComp <- StaniszCompartment$new(
  radius = 1e-6,
  diffusivity = 2.0e-9
)
staniszComp$get_signal(0.03, 0.03, 0.040)

neumanComp <- NeumanCompartment$new(
  radius = 1e-6,
  diffusivity = 2.0e-9
)
neumanComp$get_signal(0.03, 0.03, 0.040, echo_time = 0.040)

callaghanComp <- CallaghanCompartment$new(
  radius = 1e-6,
  diffusivity = 2.0e-9
)
callaghanComp$get_signal(0.03, 0.03, 0.040)

vanGelderenComp <- VanGelderenCompartment$new(
  radius = 1e-6,
  diffusivity = 2.0e-9
)
vanGelderenComp$get_signal(0.03, 0.03, 0.040)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CylinderRadialCompartment-new}{\code{CylinderRadialCompartment$new()}}
\item \href{#method-CylinderRadialCompartment-get_signal}{\code{CylinderRadialCompartment$get_signal()}}
\item \href{#method-CylinderRadialCompartment-clone}{\code{CylinderRadialCompartment$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CylinderRadialCompartment-new"></a>}}
\if{latex}{\out{\hypertarget{method-CylinderRadialCompartment-new}{}}}
\subsection{Method \code{new()}}{
Instantiates a new cylinder radial compartment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CylinderRadialCompartment$new(radius, diffusivity)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{radius}}{A numeric value specifying the radius of the cylinder in
meters.}

\item{\code{diffusivity}}{A numeric value specifying the diffusivity within the
cylinder in m\eqn{^2}.s\eqn{^{-1}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of the \code{\link{CylinderRadialCompartment}} class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CylinderRadialCompartment-get_signal"></a>}}
\if{latex}{\out{\hypertarget{method-CylinderRadialCompartment-get_signal}{}}}
\subsection{Method \code{get_signal()}}{
Computes the signal attenuation predicted by the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CylinderRadialCompartment$get_signal(
  small_delta,
  big_delta,
  G,
  echo_time = NULL,
  n_max = 20L,
  m_max = 50L
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{small_delta}}{A numeric value specifying the duration of the
gradient pulse in seconds.}

\item{\code{big_delta}}{A numeric value specifying the duration between the
gradient pulses in seconds.}

\item{\code{G}}{A numeric value specifying the strength of the gradient in
T.m\eqn{^{-1}}.}

\item{\code{echo_time}}{A numeric value specifying the echo time in seconds.}

\item{\code{n_max}}{An integer value specifying the maximum order of the Bessel
function. Defaults to \code{20L}.}

\item{\code{m_max}}{An integer value specifying the maximum number of extrema
for the Bessel function. Defaults to \code{50L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric value storing the predicted signal attenuation.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sodermanComp <- SodermanCompartment$new(
  radius = 1e-6,
  diffusivity = 2.0e-9
)
sodermanComp$get_signal(0.03, 0.03, 0.040)

staniszComp <- StaniszCompartment$new(
  radius = 1e-6,
  diffusivity = 2.0e-9
)
staniszComp$get_signal(0.03, 0.03, 0.040)

neumanComp <- NeumanCompartment$new(
  radius = 1e-6,
  diffusivity = 2.0e-9
)
neumanComp$get_signal(0.03, 0.03, 0.040, echo_time = 0.040)

callaghanComp <- CallaghanCompartment$new(
  radius = 1e-6,
  diffusivity = 2.0e-9
)
callaghanComp$get_signal(0.03, 0.03, 0.040)

vanGelderenComp <- VanGelderenCompartment$new(
  radius = 1e-6,
  diffusivity = 2.0e-9
)
vanGelderenComp$get_signal(0.03, 0.03, 0.040)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CylinderRadialCompartment-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CylinderRadialCompartment-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CylinderRadialCompartment$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
