% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multialign.R
\name{backTranslate}
\alias{backTranslate}
\title{Replace amino acids with codons}
\usage{
backTranslate(aa.msa, nuc.ffn)
}
\arguments{
\item{aa.msa}{A fasta object with a multiple alignment, see \code{\link{msalign}}.}

\item{nuc.ffn}{A fasta object with the coding sequences, see \code{\link{readFasta}}.}
}
\value{
A fasta object similar to \code{aa.msa}, but where each amino acid has been replace by 
its corresponding codon. All gaps \samp{"-"} are replaced by triplets \samp{"---"}.
}
\description{
Replaces aligned amino acids with their original codon triplets.
}
\details{
This function replaces the aligned amino acids in \code{aa.msa} with their
original codon triplets. This is possible only when the nucleotide sequences in \code{nuc.ffn}
are the exact nucleotide sequences behind the protein sequences that are aligned in \code{aa.msa}.

It is required that the first token of the \samp{Header} lines is identical for a protein sequence
in \code{aa.msa} and its nucleotide version in \samp{nuc.ffn}, otherwise it is impossible to
match them. Thus, they may not appear in the same order in the two input fasta objects.

When aligning coding sequences, one should in general always align their protein sequences, to
keep the codon structure, and then use \code{\link{backTranslate}} to convert this into a 
nucleotide alignment, if required.

If the nuclotide sequences contain the stop codons, these will be removed.
}
\examples{
msa.file <- file.path(file.path(path.package("microseq"),"extdata"), "small.msa")
aa.msa <- readFasta(msa.file)
nuc.file <- file.path(file.path(path.package("microseq"),"extdata"), "small.ffn")
nuc <- readFasta(nuc.file)
nuc.msa <- backTranslate(aa.msa, nuc)

}
\seealso{
\code{\link{msalign}}, \code{\link{readFasta}}.
}
\author{
Lars Snipen.
}
