% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_performance.R
\name{calculate_growth_performance}
\alias{calculate_growth_performance}
\alias{calculate_percentage_change}
\alias{summarize_growth_performance}
\alias{summarise_growth_performance}
\alias{plot_growth_performance}
\title{Calculate and visualize growth performance}
\usage{
calculate_growth_performance(
  input_data,
  treatment_grouping = FALSE,
  concentration_grouping = FALSE,
  group = "Group",
  experiment = "Experiment",
  treatment = "Treatment",
  concentration = "Concentration",
  timepoint = "Timepoint",
  value = "Value",
  control_mean = "control_mean"
)

calculate_percentage_change(input, reference)

summarize_growth_performance(
  input_data,
  compute_sd = FALSE,
  grouping = c("Group", "Treatment", "Concentration", "Timepoint"),
  treatment = "Treatment",
  value = "Value"
)

plot_growth_performance(
  input_data,
  stats_data = NULL,
  level_unit = NULL,
  treatment_order = NULL,
  apply_sign_test = FALSE,
  grouping = NULL,
  x_var = "Treatment",
  y_var = "mean",
  error_var = "stderr",
  x_lab = "Treatment",
  y_lab = NULL,
  fill_var = "Concentration",
  row_facets = NULL,
  col_facets = "Group",
  value = "Value",
  p_values = "p.signif",
  level_colors = NULL,
  ...
)
}
\arguments{
\item{input_data}{A data frame containing summarized data, e.g. from function call to \code{summarize_growth_performance}.}

\item{treatment_grouping}{A Boolean value that specifies whether or not (default) there is a treatment grouping within the plate.}

\item{concentration_grouping}{A Boolean value that specifies whether or not (default) there is a concentration grouping within the plate.}

\item{group}{The column containing group information. Defaults to 'Group'.}

\item{experiment}{The column containing experiment information. Defaults to 'Experiment'. The hierarchy is group > experiment, i.e.
within a single group, there might be several experiments taking place (e.g. multiple extracts from the same plant species
tested with plant species being the group and type of extract being the experiment).}

\item{treatment}{The column containing treatment information. Defaults to 'Treatment'.}

\item{concentration}{The column containing concentration information. Defaults to 'Concentration'.}

\item{timepoint}{The column containing timepoint information. Defaults to 'Timepoint'.}

\item{value}{The column containing the absorption values to be assessed via \code{apply_sign_test}. Defaults to 'Value'.}

\item{control_mean}{he column containing the absorption values to calculate growth performance. Defaults to 'control_mean'.}

\item{input}{A single numeric value.}

\item{reference}{A single numeric value serving as the baseline for comparison.}

\item{compute_sd}{Logical, indicating whether to compute the standard deviation (default) or standard error.}

\item{grouping}{Optional. A character vector specifying the grouping variables on which to apply the sign
test. If not specified and 'apply_sign_test' is set to TRUE, then the test will be applied on the
whole dataset.}

\item{stats_data}{Optional. A data frame containing growth performance data, e.g. from function call to
\code{calculate_growth_performance}. Only necessary, if 'apply_sign_test' parameter is set to TRUE.}

\item{level_unit}{Optional. The unit of applied concentrations to display on the y-axis.}

\item{treatment_order}{Optional. An alternative order of factor levels on the x-axis.}

\item{apply_sign_test}{Logical. Should the sign test be applied to specified levels? For this, the 'stats_data' and
'grouping' parameters need to be specified.}

\item{x_var}{The variable name for the x-axis. Defaults to "Treatment".}

\item{y_var}{The variable name for the y-axis. Defaults to "mean".}

\item{error_var}{The variable name to generate the error bars. Defaults to 'stderr'.}

\item{x_lab}{The label for the x-axis. Defaults to "Treatment".}

\item{y_lab}{Optional. The label for the y-axis. If not provided will return "Relative growth performance".}

\item{fill_var}{The variable used to fill facets. Defaults to "Concentration".}

\item{row_facets}{A character vector specifying nested column facets. Defaults to \code{NULL}.}

\item{col_facets}{A character vector specifying nested row facets. Defaults to "Group".}

\item{p_values}{The column containing the (adjusted) p-values. Defaults to 'p.adj.signif' from a
function call to \code{apply_sign_test} and \code{rstatix::sign_test}.}

\item{level_colors}{Optional. The colors for different levels. If not specified, will be determined
based on levels of 'fill_var' using \code{gray.colors}.}

\item{...}{Additional arguments to be passed to \code{\link{apply_sign_test}}.}
}
\value{
\code{calculate_growth_performance} returns a modified data frame with the control mean subtracted from each treatment level for each concentration level, applied within each experiment.

\code{calculate_percentage_change} returns a numeric vector containing the percentage change for each value in the vector compared to the reference.

\code{summarize_growth_performance} returns a data frame containing the summary statistics.

\code{plot_growth_performance} returns a ggplot object.
}
\description{
\code{calculate_growth_performance} standardizes data by subtracting the average value of the control group from each treatment level
for each concentration level, applied within each experiment. It assumes the input data is a data frame with columns 'Experiment', 'Concentration', 'Treatment', 
and 'Value', where 'Concentration' represents different concentration levels, 'Treatment' represents different 
treatment groups, and 'Value' represents the corresponding absorption values.

\code{calculate_percentage_change} calculates the percentage change between a vector of values (or a
single value) and a reference value as the baseline. If a value in the vector is less than the reference, it returns
the negative percentage difference; otherwise, it returns the positive percentage difference.

\code{summarize_growth_performance} summarizes a data frame containing growth performance by
computing the mean and either the standard error or standard deviation.

\code{plot_growth_performance} visualizes growth performance using bar charts with error bars.
}
\details{
\code{plot_growth_performance} uses ggplot2 to create bar charts of summarized data with error bars.
}
\seealso{
\code{\link{tidy_single_plate}}, \code{\link{tidy_plates_via_params}}, \code{\link{tidy_plates_via_prompts}}
}
