% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{betatest}
\alias{betatest}
\title{PERMANOVA test for phyloseq}
\usage{
betatest(physeq, group, distance = "bray")
}
\arguments{
\item{physeq}{A \code{phyloseq} object containing merged information of abundance,
taxonomic assignment, sample data including the measured variables and categorical information
of the samples, and / or phylogenetic tree if available.}

\item{group}{(Required). Character string specifying name of a categorical variable that is preferred for grouping the information.
information.}

\item{distance}{A string character specifying dissimilarity index to be used in calculating pairwise distances (Default index is "bray".).
"unifrac","wunifrac","manhattan", "euclidean", "canberra", "bray", "kulczynski", "jaccard", "gower", "altGower",
"morisita", "horn", "mountford", "raup" , "binomial", "chao", "cao" or "mahalanobis".}
}
\value{
PERMANOVA test result
}
\description{
PERMANOVA test for phyloseq
}
\examples{
{
data("Physeq")
phy<-normalize(physeq)
beta <-betatest(phy,group="SampleType")
}
}
\author{
Kai Guo
}
